
//
// The contents of this file are subject to the Mozilla Public License Version 1.0 (the "License");
// you may not use this file except in compliance with the License. You may obtain a copy of the
// License at http://www.mozilla.org/MPL/ 
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied.
// See the License for the specific language governing rights and limitations under the License. 
//
// The Original Code is: all this file. 
//
// The Initial Developer of the Original Code is
// Trevor Nash of Melvaig Software Engineering Limited (tcn@melvaig.co.uk).
//
// Portions created by (your name) are Copyright (C) (your legal entity). All Rights Reserved. 
//
// Contributor(s): none. 
//

import com.icl.saxon.resolvers.InternalURIResolver;
import com.icl.saxon.TransformerFactoryImpl;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.String;
import java.lang.System;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;

public class TestInternalURIResolver {


    public static void main (String[] args)
    throws TransformerException, FileNotFoundException {
        
        InternalURIResolver resolver = new InternalURIResolver();
        //resolver.putResult("d3");  // see t1.xsl and t2.xsl

        
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setURIResolver (resolver);
        //((TransformerFactoryImpl)factory).setOutputURIResolver (resolver);

        
        Transformer t1 = factory.newTransformer(
                new StreamSource(new FileInputStream("t1.xsl")));
        t1.transform(
            new StreamSource(new FileInputStream("input.xml")),
            new StreamResult (System.out));
        Transformer t2 = factory.newTransformer(
                new StreamSource(new FileInputStream("t2.xsl")));
        t2.transform(
            new StreamSource(new FileInputStream("input.xml")),
            new StreamResult (System.out));

    }

}
       