
//
// The contents of this file are subject to the Mozilla Public License Version 1.0 (the "License");
// you may not use this file except in compliance with the License. You may obtain a copy of the
// License at http://www.mozilla.org/MPL/ 
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied.
// See the License for the specific language governing rights and limitations under the License. 
//
// The Original Code is: all this file. 
//
// The Initial Developer of the Original Code is
// Trevor Nash of Melvaig Software Engineering Limited (tcn@melvaig.co.uk).
//
// Portions created by (your name) are Copyright (C) (your legal entity). All Rights Reserved. 
//
// Contributor(s): none. 
//
package com.icl.saxon.resolvers;
import com.icl.saxon.OutputURIResolver;
import java.io.IOException;
import java.lang.String;
import java.lang.System;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;

public class OutputURILogger implements OutputURIResolver {

    public OutputURILogger () {}

    
    /**
     * Called by the processor when it encounters
     * an xsl:document element.
     *
     * @param href An href attribute, which may be relative or absolute.
     * @param base The base URI in effect when the href attribute
     * was encountered.
     * @param attributes The attributes of the xsl:document element, after
     * AVT expansion.
     *
     * @return A Result object, or null if the href cannot be resolved,
     * and the processor should try to resolve the URI itself.
     *
     * @throws TransformerException if an error occurs when trying to
     * resolve the URI.
     */
    public Result resolveNew (
            String href,
            String base,
            Properties attributes)
        throws TransformerException
    {
        System.out.println("Output URI resolved: "+href);
        try {
            attributes.store (System.out, "attributes:");
        } catch (IOException err) {
            throw new TransformerException("Failed to write attributes", err);
        }
        return null;
    }

}
       