<?xml version="1.0" encoding="utf-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:sch="http://www.ascc.net/xml/schematron" version="1.1">

<xsl:import href="skeleton1-5.xsl"/>

<xsl:template name="process-prolog">
   <axsl:output method="text"/>
</xsl:template>


	<xsl:template match="sch:emph | emph" mode="text">
		<axsl:text xml:space="preserve"> </axsl:text>
		<xsl:call-template name="process-emph"/>
		<axsl:text xml:space="preserve"> </axsl:text>
	</xsl:template>

<xsl:template name="process-root">
   <xsl:param name="title"/>
   <xsl:param name="contents"/>
   <xsl:value-of select="$title"/>
   <xsl:text>
</xsl:text>
   <xsl:copy-of select="$contents"/>
</xsl:template>

<!-- use default rule for process-pattern: ignore name and see -->
<!-- use default rule for process-name: output name -->
<!-- use default rule for process-assert and process-report:
     call process-message -->

<xsl:template name="process-message">
   <xsl:param name="pattern"/>
   <xsl:param name="role"/>
   <axsl:value-of select="saxon:systemId()"/>
   <axsl:text>:</axsl:text>
   <axsl:value-of select="saxon:lineNumber()"/>
   <xsl:if test="$role">
      <xsl:text> (</xsl:text>
      <xsl:value-of select="$role"/>
      <xsl:text>)</xsl:text>
   </xsl:if>:
   <xsl:apply-templates mode="text"/>
   <xsl:text>
</xsl:text>
</xsl:template>


</xsl:transform>