<?xml version="1.0" encoding="utf-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:sch="http://www.ascc.net/xml/schematron" xmlns:m21processor="java:com.melvaig.m21.M21Processor" xmlns:saxon="http://icl.com/saxon" version="1.1">

<xsl:import href="skeleton1-5.xsl"/>

<xsl:template name="process-prolog">
   <!-- insert exclude-result-prefixes to save cluttering up the HTML-->
   <xsl:attribute name="exclude-result-prefixes">
		<xsl:for-each select="sch:ns | ns">
			<xsl:value-of select="concat(@prefix,' ')"/>
		</xsl:for-each>
      <xsl:value-of select="'sch'"/>
   </xsl:attribute>
   <axsl:output method="html"/>
   <axsl:param name="m21" select="/.."/>
   <axsl:param name="m21.mapper" select="/.."/>
   <axsl:param name="m21.dir"/>
</xsl:template>


	<xsl:template match="sch:emph | emph" mode="text">
		<axsl:text xml:space="preserve"> </axsl:text>
		<xsl:call-template name="process-emph"/>
		<axsl:text xml:space="preserve"> </axsl:text>
	</xsl:template>

<xsl:template name="process-root">
   <xsl:param name="title"/>
   <xsl:param name="contents"/>
   <html>
      <head>
         <title><xsl:value-of select="$title"/></title>
         <link rel="stylesheet" href="{{$m21.dir}}/m21-html.css" type="text/css"/>
         <SCRIPT TYPE="text/javascript" LANGUAGE="JavaScript">

   function fGoToLine(obj) {
      return "&lt;xref xmlns='http://melvaig.com/m21' base='"
               +document.URL+"' file='"
               +obj.file+"' line='"+obj.line+"'/&gt;"
   }

   function fOnDragStart() {
      obj = window.event.srcElement

      if (obj.className == "m21edit") {

         if (!window.event.dataTransfer) {

            alert("This version of IE does not support Drag and Drop")
            return
         }
         window.event.dataTransfer.clearData(); // remove image information
         window.event.dataTransfer.setData("Text", fGoToLine(obj));
	 window.event.dataTransfer.effectAllowed="copy";
      }
   }

</SCRIPT>
      </head>
      <body>
         <div class="m21ReportTitle">
            <xsl:value-of select="$title"/>
         </div>
         <axsl:variable name="contents">
            <xsl:copy-of select="$contents"/>
         </axsl:variable>
         <div class="m21HelpText">
            <axsl:if test="string($contents)">
                Your specification contains the following errors.
                Drag the edit icon to edit.
            </axsl:if>
            <axsl:if test="not(string($contents))">
                No errors found.
            </axsl:if>
         </div>
         <axsl:copy-of select="$contents"/>
      </body>
   </html>
</xsl:template>

<!-- use default rule for process-pattern: ignore name and see -->
<!-- use default rule for process-name: output name -->

<!-- use default rule for process-assert and process-report:
     call process-message -->

<xsl:template name="process-message">
   <xsl:param name="pattern"/>
   <xsl:param name="role"/>
   <axsl:if test="$m21">
      <!-- returns nothing, just notifies M21 there is an error -->
      <axsl:value-of select="m21processor:validationFail($m21)"/>
   </axsl:if>
   <div class="m21jump">
      <axsl:variable name="file" select="saxon:if($m21.mapper,               m21mapper:toRelativePath($m21.mapper,               substring-after (saxon:systemId(), '/')),               substring-after (saxon:systemId(), '/'))"/>
      <img class="m21edit" src="{{$m21.dir}}/m21-edit-drag.gif" file="{{$file}}" line="{{saxon:lineNumber()}}" onDragStart="fOnDragStart();"/>
      <axsl:value-of select="$file"/>
      <axsl:text>:</axsl:text>
      <axsl:value-of select="saxon:lineNumber()"/>
      <xsl:if test="$role">
         <xsl:text> (</xsl:text>
         <xsl:value-of select="$role"/>
         <xsl:text>)</xsl:text>
      </xsl:if>:
   </div>
   <div class="m21message">
      <xsl:apply-templates mode="text"/>
   </div>
</xsl:template>


</xsl:transform>