<?xml version="1.0" encoding="utf-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:saxon="http://icl.com/saxon" exclude-result-prefixes="saxon" version="1.1">

<xsl:output method="xml" indent="yes"/>


<xsl:template match="JarContent">
   <class-library>
      <!-- pick out the File elements for .class files other than inner classes -->
      <saxon:group xsl:extension-element-prefixes="saxon" select="File[@ext='class' and not(contains(., '$'))]" group-by="@dir">
         <xsl:sort select="@dir"/>
         <package name="{translate(@dir, '/', '.')}">
            <saxon:item>
               <class name="{substring(., 1, string-length(.)-string-length('.class'))}"/>
            </saxon:item>
         </package>
      </saxon:group>
   </class-library>
</xsl:template>


</xsl:transform>