<?xml version="1.0" encoding="utf-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m21="http://melvaig.com/m21" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:saxon="http://icl.com/saxon" xmlns:db="http://nwalsh.com/docbook/xml/3.1.4/db3xml.dtd" version="1.1">

      <xsl:import href="m21core.xsl"/>
      <xsl:namespace-alias stylesheet-prefix="axsl" result-prefix="xsl"/>
      <xsl:output method="text"/>
   

  <saxon:function name="m21:find-imports">
     <xsl:param name="imports"/>
     <!-- returns &m21ns;:export nodes -->
     <xsl:choose>
        <xsl:when test="count($imports)=0">
           <saxon:return select="/.."/>
        </xsl:when>
        <xsl:otherwise>
           <xsl:variable name="tail" select="$imports[position()&gt;1]"/>
           <xsl:variable name="head" select="$imports[1]"/>
           <xsl:variable name="export-uri" select="concat($head/@name, '.m21/export.xml')"/>
           <xsl:variable name="export" select="document($export-uri)/m21:export"/>
           <xsl:if test="count($export)=0">
              <xsl:for-each select="$head">
                 <xsl:message terminate="yes">
                    <xsl:value-of select="saxon:systemId()"/>
                    <xsl:text>:</xsl:text>
                    <xsl:value-of select="saxon:lineNumber()"/>
                    <xsl:text>Import document '</xsl:text>
                    <xsl:value-of select="$export-uri"/>
                    <xsl:text>' not found</xsl:text>
                 </xsl:message>
              </xsl:for-each>
           </xsl:if>
           <saxon:return select="$export |                                  m21:find-imports($export/m21:import) |                                  m21:find-imports($tail)"/>
        </xsl:otherwise>
     </xsl:choose>
  </saxon:function>
  
<xsl:variable name="imported" select="m21:find-imports(/*/m21:import)"/>
  
         <xsl:param name="m21.dir" select="."/>
  
<xsl:variable name="local-objects" select="//m21:object"/>
<xsl:variable name="objects" select="$local-objects | $imported/m21:object"/>
<xsl:variable name="object-names" select="saxon:distinct($objects/@name)"/>
<xsl:template match="/">
   
     <xsl:for-each select="$imported">
        <xsl:message>
           <xsl:text>Imports </xsl:text>
           <xsl:value-of select="saxon:systemId()"/>
        </xsl:message>
     </xsl:for-each>
  
         <xsl:variable name="exports" select="/*/m21:export"/>
         <xsl:document href="{$m21.dir}/export.xml" method="xml">
            <sk:export xmlns:sk="http://melvaig.com/m21">
               <!-- copy the namespaces - though this is no 
                    guarantee everything will work out right in
                    the importing document -->
               <xsl:for-each select="$exports">
                  <xsl:for-each select="saxon:tokenize(@prefixes)">
                     <xsl:variable name="prefix" select="string(.)"/>
                     <xsl:copy-of select="namespace::*[name()=$prefix]"/>
                  </xsl:for-each>
               </xsl:for-each>
               <!-- copy import statements other than private ones -->
               <xsl:copy-of select="/*/m21:import[not(@private)]"/>
               <!-- copy the objects which have prefixes matching the
                    selected namespaces. -->
               <xsl:for-each select="$exports">
                  <xsl:for-each select="saxon:tokenize(@prefixes)">
                     <xsl:variable name="prefix" select="string(.)"/>
                     <xsl:copy-of select="$local-objects[starts-with(@name, $prefix)]"/>
                  </xsl:for-each>
               </xsl:for-each>
            </sk:export>
         </xsl:document>
  
   <xsl:document href="internal:expandSpec" method="xml">
      <axsl:transform>
         <xsl:copy-of select="$object-namespaces"/>
         <xsl:attribute name="version">1.1</xsl:attribute>
         

         <axsl:template match="/">
            <m21:expanded>
               <axsl:apply-templates/>
            </m21:expanded>
         </axsl:template>

         
   <xsl:for-each select="$objects/m21:replace/m21:declare">
      <xsl:apply-templates mode="copy"/>
   </xsl:for-each>
   <xsl:for-each select="$object-namespaces">
      <!-- default replace copies the macro call, possibly replacing embedded
           objects
        -->
      <xsl:variable name="pattern" select="    concat('*[namespace-uri()=&#34;',    concat(string(.), '&#34;]'))"/>
      <xsl:variable name="t-name" select="concat('r_', generate-id())"/>
      <axsl:template match="{$pattern}" name="{$t-name}">
         <axsl:copy>
            <axsl:copy-of select="@*"/>
            <axsl:if test="not(@m21:replace)">
                <axsl:attribute name="m21:replace">done</axsl:attribute>
            </axsl:if>
            <axsl:apply-templates mode="copy"/>
         </axsl:copy>
      </axsl:template>
      <axsl:template match="{$pattern}" mode="copy">
         <axsl:call-template name="{$t-name}"/>
      </axsl:template>
   </xsl:for-each>

   <xsl:for-each select="$object-names">
      <xsl:variable name="object-name" select="string(.)"/>
      <!-- replace specs - there may be more than one - interpret the replace
           body.  The call itself is copied intact.
        -->
      <saxon:group xsl:extension-element-prefixes="saxon" select="$objects[@name=$object-name]/m21:replace" group-by="saxon:if(@match, @match, $object-name)">
         <xsl:sort select="saxon:if(@match, @match, $object-name)"/>
         <xsl:variable name="match" select="saxon:if(@match, @match, $object-name)"/>
         <xsl:variable name="t-name" select="generate-id()"/>
         <axsl:template match="{$match}[not(@m21:replace)]" name="{$t-name}" priority="{2+contains($match, '[')}">
            <axsl:copy>
               <axsl:copy-of select="@*"/>
               <axsl:attribute name="m21:replace">done</axsl:attribute>
               <xsl:variable name="template">
                  <saxon:item>
                     <xsl:apply-templates mode="copy-replace"/>
                  </saxon:item>
               </xsl:variable>
               <xsl:choose>
                  <xsl:when test="count($template/*)=0">
                     <xsl:copy-of select="$template"/>
                  </xsl:when>
                  <xsl:otherwise>
               <axsl:variable name="expansion">
                  <xsl:copy-of select="$template"/>
               </axsl:variable>
               <axsl:apply-templates select="$expansion/node()" mode="copy"/>
                  </xsl:otherwise>
               </xsl:choose>
            </axsl:copy>
         </axsl:template>
         <axsl:template match="{$match}[not(@m21:replace)]" mode="copy" priority="{2+contains($match, '[')}">
            <axsl:call-template name="{$t-name}"/>
         </axsl:template>
      </saxon:group>
   </xsl:for-each>
   

         <axsl:template match="m21:object"/>
         <axsl:template match="m21:export"/>
         <axsl:template match="text()|processing-instruction()|comment()"/>
         <axsl:template match="m21:*">
            <axsl:apply-templates select="." mode="copy"/>
         </axsl:template>

         <axsl:template match="@* | node()" mode="copy">
            <axsl:copy>
               <axsl:apply-templates select="@* | node()" mode="copy"/>
            </axsl:copy>
         </axsl:template>
      </axsl:transform>
   </xsl:document>
   
   <xsl:document href="internal:generateSpec" method="xml">
      <axsl:transform>
         <xsl:copy-of select="$object-namespaces"/>
         <xsl:attribute name="version">1.1</xsl:attribute>

         <axsl:import href="http://melvaig.com/m21/m21core.xsl"/>

         
   <xsl:for-each select="$objects/m21:generate/m21:declare">
      <xsl:apply-templates mode="copy"/>
   </xsl:for-each>
   <xsl:for-each select="$object-namespaces">
      <!-- default generate copies the macro call, possibly replacing embedded
           objects
        -->
      <xsl:variable name="pattern" select="    concat('*[namespace-uri()=&#34;',    concat(string(.), '&#34;]'))"/>
      <axsl:template match="{$pattern}" mode="generate">
         <axsl:copy>
            <axsl:copy-of select="@*"/>
            <axsl:if test="not(@m21:generate)">
                <axsl:attribute name="m21:generate">done</axsl:attribute>
            </axsl:if>
            <axsl:apply-templates mode="generate"/>
         </axsl:copy>
      </axsl:template>
   </xsl:for-each>

   <xsl:for-each select="$object-names">
      <xsl:variable name="object-name" select="string(.)"/>

      <!-- generate specs - there may be more than one - interpret the replace
           body.  The call itself is copied intact.
        -->
      <saxon:group xsl:extension-element-prefixes="saxon" select="$objects[@name=$object-name]/m21:generate" group-by="saxon:if(@match, @match, $object-name)">
         <xsl:sort select="saxon:if(@match, @match, $object-name)"/>
         <xsl:variable name="match" select="saxon:if(@match, @match, $object-name)"/>
         <xsl:variable name="t-name" select="generate-id()"/>
         <axsl:template match="{$match}[not(@m21:generate)]" mode="generate" name="{$t-name}" priority="{2+contains($match, '[')}">
            <axsl:copy>
               <axsl:copy-of select="@*"/>
               <axsl:attribute name="m21:generate">done</axsl:attribute>
               <xsl:variable name="template">
                  <saxon:item>
                     <xsl:apply-templates mode="copy-generate"/>
                  </saxon:item>
               </xsl:variable>
               <xsl:choose>
                  <xsl:when test="count($template/*)=0">
                     <xsl:copy-of select="$template"/>
                  </xsl:when>
                  <xsl:otherwise>
               <axsl:variable name="expansion">
                  <xsl:copy-of select="$template"/>
               </axsl:variable>
               <axsl:apply-templates select="$expansion/node()" mode="generate"/>
                  </xsl:otherwise>
               </xsl:choose>
            </axsl:copy>
         </axsl:template>
      </saxon:group>
   </xsl:for-each>
   
   <xsl:for-each select="$objects/m21:write/m21:declare">
      <xsl:apply-templates mode="copy"/>
   </xsl:for-each>
   <xsl:for-each select="$object-namespaces">
      <!-- default write copies the macro call body, possibly replacing embedded
           objects
        -->
      <xsl:variable name="pattern" select="    concat('*[namespace-uri()=&#34;',    concat(string(.), '&#34;]'))"/>
      <axsl:template match="{$pattern}" mode="writing">
         <axsl:param name="file.id"/>
         <axsl:param name="sink"/>
         <axsl:apply-templates mode="writing">
            <axsl:with-param name="file.id" select="$file.id"/>
            <axsl:with-param name="sink" select="$sink"/>
         </axsl:apply-templates>
      </axsl:template>
   </xsl:for-each>
   <xsl:for-each select="$object-names">
      <xsl:variable name="object-name" select="string(.)"/>

      <!-- write specs - there may be more than one - interpret the replace
           body.  The call itself is not copied unless the user does it
           themselves.
        -->
      <saxon:group xsl:extension-element-prefixes="saxon" select="$objects[@name=$object-name]/m21:write" group-by="saxon:if(@match, @match, $object-name)">
         <xsl:sort select="saxon:if(@match, @match, $object-name)"/>
         <xsl:variable name="match" select="saxon:if(@match, @match, $object-name)"/>
         <xsl:variable name="t-name" select="generate-id()"/>
         <axsl:template match="{$match}" mode="writing" name="{$t-name}" priority="{2+contains($match, '[')}">
            <axsl:param name="file.id"/>
            <axsl:param name="sink"/>
               <xsl:variable name="template">
                  <saxon:item>
                     <xsl:apply-templates mode="copy-write"/>
                  </saxon:item>
               </xsl:variable>
               <xsl:choose>
                  <xsl:when test="count($template/*)=0">
                     <xsl:copy-of select="$template"/>
                  </xsl:when>
                  <xsl:otherwise>
               <axsl:variable name="expansion">
                  <xsl:copy-of select="$template"/>
               </axsl:variable>
               <axsl:apply-templates select="$expansion/node()" mode="writing">
                  <axsl:with-param name="file.id" select="$file.id"/>
                  <axsl:with-param name="sink" select="$sink"/>
               </axsl:apply-templates>
                  </xsl:otherwise>
               </xsl:choose>
         </axsl:template>
      </saxon:group>
   </xsl:for-each>
   

      </axsl:transform>
   </xsl:document>
   
   <xsl:document href="internal:weaveSpec" method="xml">
      <axsl:transform>
         <xsl:copy-of select="$object-namespaces"/>
         <xsl:attribute name="version">1.1</xsl:attribute>

         <axsl:import href="http://melvaig.com/m21/m21-db.xsl"/>

         
   <xsl:for-each select="$objects/m21:presentation/m21:declare">
      <xsl:apply-templates select="node()" mode="copy"/>
   </xsl:for-each>
   <xsl:for-each select="$object-names">
      <!-- default copies the macro call literally, possibly 
           replacing embedded objects
        -->
      <xsl:variable name="object-name" select="string(.)"/>
      <axsl:template match="{$object-name}">
         <axsl:call-template name="user-top"/>
      </axsl:template>

      <!-- presentation specs - there may be more than one - provide
           a presentation.
        -->
      <saxon:group xsl:extension-element-prefixes="saxon" select="$objects[@name=$object-name]/m21:presentation" group-by="saxon:if(@match, @match, $object-name)">
         <xsl:sort select="saxon:if(@match, @match, $object-name)"/>
         <xsl:variable name="match" select="saxon:if(@match, @match, $object-name)"/>
         <xsl:variable name="t-name" select="concat('w-',generate-id())"/>
         <axsl:template match="{$match}" priority="{2+contains($match, '[')}" name="{$t-name}">
            <axsl:param name="m21:source-mode" select="false()"/>
            <axsl:variable name="m21:object" select="."/>
               <saxon:item>
                  <xsl:apply-templates mode="copy-db"/>
               </saxon:item>
         </axsl:template>
         <axsl:template match="{$match}" priority="{2+contains($match, '[')}" mode="source">
            <axsl:call-template name="{$t-name}">
               <axsl:with-param name="m21:source-mode" select="true()"/>
            </axsl:call-template>
         </axsl:template>
      </saxon:group>
   </xsl:for-each>
   

      </axsl:transform>
   </xsl:document>
   
</xsl:template>
   
<xsl:variable name="object-namespaces" select="saxon:distinct($objects/namespace::*[local-name()=substring-before(../@name, ':')])"/>
   
   <xsl:template match="@* | node()" mode="copy">
      <xsl:copy>
         <xsl:apply-templates select="@* | node()" mode="copy"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="@* | node()" mode="copy-replace">
      <xsl:copy>
         <xsl:apply-templates select="@* | node()" mode="copy-replace"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="m21:declare" mode="copy-replace">
   </xsl:template>
   <xsl:template match="m21:instantiate" mode="copy-replace">
      <axsl:apply-templates mode="copy">
         <xsl:copy-of select="@select"/>
      </axsl:apply-templates>
   </xsl:template>
   
   <xsl:template match="@* | node()" mode="copy-generate">
      <xsl:copy>
         <xsl:apply-templates select="@* | node()" mode="copy-generate"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="m21:declare" mode="copy-generate">
   </xsl:template>
   <xsl:template match="m21:instantiate" mode="copy-generate">
      <axsl:apply-templates mode="generate">
         <xsl:copy-of select="@select"/>
      </axsl:apply-templates>
   </xsl:template>
   
<xsl:template match="m21:object-reference" mode="copy-generate">
   <axsl:variable name="{@name}" select="m21:object-reference({@type}, {@object.id})"/>
</xsl:template>
   
   <xsl:template match="@* | node()" mode="copy-write">
      <xsl:copy>
         <xsl:apply-templates select="@* | node()" mode="copy-write"/>
         </xsl:copy>
   </xsl:template>
   <xsl:template match="m21:declare" mode="copy-write"/>
   <xsl:template match="m21:instantiate" mode="copy-write">
      <axsl:apply-templates mode="writing">
         <xsl:copy-of select="@select"/>
         <axsl:with-param name="file.id" select="$file.id"/>
         <axsl:with-param name="sink" select="$sink"/>
      </axsl:apply-templates>
   </xsl:template>
   
<xsl:template match="db:*" mode="copy-db">
   <xsl:param name="object" select="/.."/>
   <xsl:element name="{local-name()}"> <!-- to avoid copying the db prefix -->
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="node()" mode="copy-db">
         <xsl:with-param name="object" select="$object"/>
      </xsl:apply-templates>
   </xsl:element>
</xsl:template>

<xsl:template match="*" priority="-1" mode="copy-db">
         <xsl:param name="object" select="/.."/>
         <xsl:element name="{name()}" namespace="{namespace-uri()}">
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="node()" mode="copy-db">
               <xsl:with-param name="object" select="$object"/>
            </xsl:apply-templates>
         </xsl:element>
</xsl:template>

<xsl:template match="comment()|processing-instruction()" priority="-1" mode="copy-db">
   <xsl:copy/>
</xsl:template>

<xsl:template match="m21:declare" mode="copy-db"/>
<xsl:template match="m21:instantiate" mode="copy-db">
   <xsl:choose>
      <xsl:when test="@mode">
         <axsl:apply-templates mode="{@mode}">
            <xsl:copy-of select="@select"/>
         </axsl:apply-templates>
      </xsl:when>
      <xsl:otherwise>
   <axsl:choose>
      <axsl:when test="$m21:source-mode">
         <axsl:apply-templates mode="source">
            <xsl:copy-of select="@select"/>
         </axsl:apply-templates>
      </axsl:when>
      <axsl:otherwise>
         <axsl:apply-templates>
            <xsl:copy-of select="@select"/>
         </axsl:apply-templates>
      </axsl:otherwise>
   </axsl:choose>
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>
<xsl:template match="m21:listing" mode="copy-db">
   <axsl:variable name="file" select="substring-after (saxon:systemId(), '/')"/>
   <m21:xref file="{{$file}}" line="{{saxon:lineNumber()}}">
      <programlisting>
          <axsl:apply-templates select="node()" mode="source">
             <xsl:if test="@select">
                <xsl:attribute name="select">
                   <xsl:value-of select="@select"/>
                </xsl:attribute>
             </xsl:if>
          </axsl:apply-templates>
      </programlisting>
   </m21:xref>
</xsl:template>
   

</xsl:transform>