<?xml version="1.0" encoding="utf-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m21="http://melvaig.com/m21" xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias" xmlns:saxon="http://icl.com/saxon" xmlns:cfg="http://melvaig.com/m21/configuration" version="1.1">

      <xsl:output method="text"/>
      <xsl:param name="home" select="'.'"/>
      <xsl:namespace-alias stylesheet-prefix="axsl" result-prefix="xsl"/>
      <xsl:key name="by-id" match="*" use="@id"/>
      <xsl:strip-space elements="*"/>
      <xsl:preserve-space elements="cfg:text"/>
   

<xsl:template match="/">
Processing M21 options file <xsl:value-of select="saxon:systemId()"/>
   
<xsl:document href="internal:editGoTo.xsl" method="xml" indent="yes">
   <!-- we are trying to generate something like
      <xsl:script implements-prefix="runtime" language="java" src="java:java.lang.Runtime" />
      <xsl:template match="m21:xref">
         <xsl:variable name="command">pfe /g <xsl:value-of select="@line" /> "<xsl:value-of select="@file" />"</xsl:variable>
         <xsl:value-of select="runtime:exec(runtime:getRuntime(), $command)" />
      </xsl:template>
     -->
   <axsl:transform>
      <xsl:apply-templates select="cfg:configuration/cfg:interfaces/cfg:prefix" mode="editors-namespaces"/>
      <xsl:attribute name="version">1.1</xsl:attribute>
      <axsl:output method="text"/>
      <xsl:apply-templates select="cfg:configuration/cfg:editors" mode="editors"/>
   </axsl:transform>
</xsl:document>

</xsl:template>
   
<xsl:template match="cfg:editors" mode="editors">
   <xsl:apply-templates select="cfg:editor[@id=current()/@default]" mode="editors"/>
</xsl:template>

<xsl:template match="cfg:call" mode="editors">
   <xsl:apply-templates select="key('by-id', @method.id)" mode="editors">
      <xsl:with-param name="call" select="."/>
   </xsl:apply-templates>
</xsl:template>

<xsl:template match="cfg:method" mode="editors">
   <xsl:param name="call"/>
   <xsl:apply-templates select="key('by-id', saxon:tokenize(@prefixes))" mode="editors"/>
   <axsl:template match="m21:xref">
      <!-- variables for the argument values -->
      <xsl:apply-templates select="$call/cfg:argument" mode="editors"/>
      <!-- <xsl:value-of select="runtime:exec(runtime:getRuntime(), $command)" /> -->
      <axsl:value-of>
         <xsl:attribute name="select">
            <xsl:apply-templates select="*" mode="editors"/>
         </xsl:attribute>
      </axsl:value-of>
   </axsl:template>
</xsl:template>
   
<xsl:template match="cfg:prefix" mode="editors">
   <axsl:script implements-prefix="{@id}" language="java" src="java:{@src}"/>
</xsl:template>
   
<xsl:template match="cfg:prefix" mode="editors-namespaces">
   <xsl:variable name="dummy">
      <xsl:element name="{@id}:dummy" namespace="java:{@src}"/>
   </xsl:variable>
   <xsl:copy-of select="$dummy/*/namespace::*[string()=concat('java:', current()/@src)]"/>
</xsl:template>
   
<xsl:template match="cfg:call/cfg:argument" mode="editors">
   <!-- <xsl:variable name="command">pfe /g <xsl:value-of select="@line" /> "<xsl:value-of select="@file" />"</xsl:variable> -->
   <axsl:variable name="{@name}">
      <xsl:apply-templates mode="editors"/>
   </axsl:variable>
</xsl:template>
   
<xsl:template match="cfg:method/cfg:argument" mode="editors">
   <xsl:text>$</xsl:text><xsl:value-of select="@name"/>
</xsl:template>
   
<xsl:template match="cfg:file" mode="editors">
   <axsl:value-of xmlns:mapper="java:com.melvaig.java.io.PathMapper" select="mapper:toAbsolutePath(@base, @file)" mapper:dummy=""/>
</xsl:template>
   
<xsl:template match="cfg:line" mode="editors">
   <axsl:value-of select="@line"/>
</xsl:template>
   
<xsl:template match="cfg:text|text()" mode="editors">
   <xsl:value-of select="."/>
</xsl:template>
   

</xsl:transform>