<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<axsl:stylesheet xmlns:axsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sch="http://www.ascc.net/xml/schematron" xmlns:m21="http://melvaig.com/m21" xmlns:saxon="http://icl.com/saxon" xmlns:m21processor="java:com.melvaig.m21.M21Processor" xmlns:m21mapper="java:com.melvaig.java.io.PathMapper" version="1.0" m21:dummy-for-xmlns="" saxon:dummy-for-xmlns="" m21processor:dummy-for-xmlns="" m21mapper:dummy-for-xmlns="">
   <axsl:output method="text"/>
   <axsl:template match="*|@*" mode="schematron-get-full-path">
      <axsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <axsl:text>/</axsl:text>
      <axsl:if test="count(. | ../@*) = count(../@*)">@</axsl:if>
      <axsl:value-of select="name()"/>
      <axsl:text>[</axsl:text>
      <axsl:value-of select="1+count(preceding-sibling::*[name()=name(current())])"/>
      <axsl:text>]</axsl:text>
   </axsl:template>
   <axsl:template match="/">M21 Schematron Schema
<axsl:apply-templates select="/" mode="M5"/>
   </axsl:template>
   <axsl:template match="m21:source" priority="4000" mode="M5">
      <axsl:choose>
         <axsl:when test="@sink.id"/>
         <axsl:otherwise>
            <axsl:value-of select="saxon:systemId()"/>
            <axsl:text>:</axsl:text>
            <axsl:value-of select="saxon:lineNumber()"/>:
   A<axsl:text xml:space="preserve"> </axsl:text>
            <axsl:value-of select="name(.)"/>
            <axsl:text xml:space="preserve"> </axsl:text>must have a<axsl:text xml:space="preserve"> </axsl:text>sink.id<axsl:text xml:space="preserve"> </axsl:text>attribute
</axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates mode="M5"/>
   </axsl:template>
   <axsl:template match="text()" priority="-1" mode="M5"/>
   <axsl:template match="text()" priority="-1"/>
</axsl:stylesheet>