<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<axsl:stylesheet xmlns:axsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sch="http://www.ascc.net/xml/schematron" xmlns:m21="http://melvaig.com/m21" xmlns:saxon="http://icl.com/saxon" xmlns:m21processor="java:com.melvaig.m21.M21Processor" xmlns:m21mapper="java:com.melvaig.java.io.PathMapper" version="1.0" m21:dummy-for-xmlns="" saxon:dummy-for-xmlns="" m21processor:dummy-for-xmlns="" m21mapper:dummy-for-xmlns="" exclude-result-prefixes="m21 saxon m21processor m21mapper sch">
   <axsl:output method="html"/>
   <axsl:param name="m21" select="/.."/>
   <axsl:param name="m21.mapper" select="/.."/>
   <axsl:param name="m21.dir"/>
   <axsl:template match="*|@*" mode="schematron-get-full-path">
      <axsl:apply-templates select="parent::*" mode="schematron-get-full-path"/>
      <axsl:text>/</axsl:text>
      <axsl:if test="count(. | ../@*) = count(../@*)">@</axsl:if>
      <axsl:value-of select="name()"/>
      <axsl:text>[</axsl:text>
      <axsl:value-of select="1+count(preceding-sibling::*[name()=name(current())])"/>
      <axsl:text>]</axsl:text>
   </axsl:template>
   <axsl:template match="/">
      <html>
         <head>
            <title>M21 Schematron Schema</title>
            <link rel="stylesheet" href="{$m21.dir}/m21-html.css" type="text/css"/>
            <SCRIPT TYPE="text/javascript" LANGUAGE="JavaScript">

   function fGoToLine(obj) {
      return "&lt;xref xmlns='http://melvaig.com/m21' base='"
               +document.URL+"' file='"
               +obj.file+"' line='"+obj.line+"'/&gt;"
   }

   function fOnDragStart() {
      obj = window.event.srcElement

      if (obj.className == "m21edit") {

         if (!window.event.dataTransfer) {

            alert("This version of IE does not support Drag and Drop")
            return
         }
         window.event.dataTransfer.clearData(); // remove image information
         window.event.dataTransfer.setData("Text", fGoToLine(obj));
	 window.event.dataTransfer.effectAllowed="copy";
      }
   }

</SCRIPT>
         </head>
         <body>
            <div class="m21ReportTitle">M21 Schematron Schema</div>
            <axsl:variable name="contents">
               <axsl:apply-templates select="/" mode="M5"/>
            </axsl:variable>
            <div class="m21HelpText">
               <axsl:if test="string($contents)">
                Your specification contains the following errors.
                Drag the edit icon to edit.
            </axsl:if>
               <axsl:if test="not(string($contents))">
                No errors found.
            </axsl:if>
            </div>
            <axsl:copy-of select="$contents"/>
         </body>
      </html>
   </axsl:template>
   <axsl:template match="m21:source" priority="4000" mode="M5">
      <axsl:choose>
         <axsl:when test="@sink.id"/>
         <axsl:otherwise>
            <axsl:if test="$m21">
               <axsl:value-of select="m21processor:validationFail($m21)"/>
            </axsl:if>
            <div class="m21jump">
               <axsl:variable name="file" select="saxon:if($m21.mapper,               m21mapper:toRelativePath($m21.mapper,               substring-after (saxon:systemId(), '/')),               substring-after (saxon:systemId(), '/'))"/>
               <img class="m21edit" src="{$m21.dir}/m21-edit-drag.gif" file="{$file}" line="{saxon:lineNumber()}" onDragStart="fOnDragStart();"/>
               <axsl:value-of select="$file"/>
               <axsl:text>:</axsl:text>
               <axsl:value-of select="saxon:lineNumber()"/>:
   </div>
            <div class="m21message">A<axsl:text xml:space="preserve"> </axsl:text>
               <axsl:value-of select="name(.)"/>
               <axsl:text xml:space="preserve"> </axsl:text>must have a<axsl:text xml:space="preserve"> </axsl:text>sink.id<axsl:text xml:space="preserve"> </axsl:text>attribute</div>
         </axsl:otherwise>
      </axsl:choose>
      <axsl:apply-templates mode="M5"/>
   </axsl:template>
   <axsl:template match="text()" priority="-1" mode="M5"/>
   <axsl:template match="text()" priority="-1"/>
</axsl:stylesheet>