<?xml version="1.0" encoding="utf-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m21="http://melvaig.com/m21" xmlns:db="http://nwalsh.com/docbook/xml/3.1.4/db3xml.dtd" xmlns:saxon="http://icl.com/saxon" exclude-result-prefixes="db saxon" version="1.1">


<xsl:template match="m21:import"/>
<xsl:template match="m21:export"/>

<xsl:template match="m21:object[*]">
   <xsl:apply-templates/>
</xsl:template>
<xsl:template match="m21:object[not(*)]">
   <programlisting>
      <xsl:apply-templates select="." mode="source"/>
   </programlisting>
</xsl:template>
<xsl:template match="m21:replace">
   <xsl:variable name="file" select="substring-after (saxon:systemId(), '/')"/>
   <xsl:variable name="label">
      <xsl:text>Object </xsl:text><xsl:value-of select="../@name"/>
      <xsl:text> replacement:</xsl:text><xsl:value-of select="@match"/>
   </xsl:variable>
   <m21:xref file="{$file}" line="{saxon:lineNumber()}" label="{$label}">
      <programlisting>
         <xsl:apply-templates select="." mode="source"/>
      </programlisting>
   </m21:xref>
</xsl:template>

<xsl:template match="m21:generate">
   <xsl:variable name="file" select="substring-after (saxon:systemId(), '/')"/>
   <xsl:variable name="label">
      <xsl:text>Object </xsl:text><xsl:value-of select="../@name"/>
      <xsl:text> generate:</xsl:text><xsl:value-of select="@match"/>
   </xsl:variable>
   <m21:xref file="{$file}" line="{saxon:lineNumber()}" label="{$label}">
      <programlisting>
         <xsl:apply-templates select="." mode="source"/>
      </programlisting>
   </m21:xref>
</xsl:template>

<xsl:template match="m21:write">
   <xsl:variable name="file" select="substring-after (saxon:systemId(), '/')"/>
   <xsl:variable name="label">
      <xsl:text>Object </xsl:text><xsl:value-of select="../@name"/>
      <xsl:text> write:</xsl:text><xsl:value-of select="@match"/>
   </xsl:variable>
   <m21:xref file="{$file}" line="{saxon:lineNumber()}" label="{$label}">
      <programlisting>
         <xsl:apply-templates select="." mode="source"/>
      </programlisting>
   </m21:xref>
</xsl:template>

<xsl:template match="m21:file">
   <xsl:choose>
      <xsl:when test="@type | @template">
         <xsl:value-of select="@name"/>
      </xsl:when>
      <xsl:otherwise>
         <xsl:variable name="file" select="substring-after (saxon:systemId(), '/')"/>
         <xsl:variable name="label">
            <xsl:value-of select="@id"/> Template <xsl:text/>
         </xsl:variable>
         <m21:xref file="{$file}" line="{saxon:lineNumber()}" label="{$label}">
            <programlisting>
               <xsl:apply-templates mode="source"/>
            </programlisting>
         </m21:xref>
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template match="m21:verbatim">
   <xsl:value-of select="." disable-output-escaping="yes"/>
</xsl:template>

<xsl:template match="m21:namespace">
   <xsl:variable name="prefix" select="@prefix"/>
   <xsl:text>xmlns:</xsl:text>
   <xsl:value-of select="local-name(namespace::*[local-name() = $prefix])"/>
   <xsl:text>="</xsl:text>
   <xsl:value-of select="string(namespace::*[local-name() = $prefix])"/>
   <xsl:text>"</xsl:text>
</xsl:template>

<xsl:template match="m21:attribute">
   <xsl:text>xmlns:</xsl:text>
   <xsl:value-of select="@name"/>
   <xsl:text>="</xsl:text>
   <xsl:value-of select="."/>
   <xsl:text>"</xsl:text>
</xsl:template>

<xsl:template match="db:*">
   <xsl:element name="{local-name()}"> <!-- to avoid copying the db prefix -->
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates select="node()"/>
   </xsl:element>
</xsl:template>

<xsl:template match="m21:source">
   <xsl:variable name="file" select="substring-after (saxon:systemId(), '/')"/>
   <xsl:variable name="label">
      <xsl:value-of select="@file.id"/>:<xsl:value-of select="@sink.id"/>
   </xsl:variable>
   <m21:xref file="{$file}" line="{saxon:lineNumber()}" label="{$label}">
      <programlisting>
          <xsl:apply-templates select="node()" mode="source"/>
      </programlisting>
   </m21:xref>
</xsl:template>

<xsl:template name="user-top">
   <xsl:variable name="file" select="substring-after (saxon:systemId(), '/')"/>
   <m21:xref file="{$file}" line="{saxon:lineNumber()}">
      <programlisting>
          <xsl:call-template name="source-mode"/>
      </programlisting>
   </m21:xref>
</xsl:template>

<xsl:template match="*" priority="-1">
   <!-- use xsl:element instead of xsl:copy to avoid copying
        superfluous namespaces e.g. m21.
        The namespace is specified explicitly in case the prefix in the
        document is bound to a different namespace in the stylesheet,
        or maybe not bound at all.
        Re. the method from XSLT programmer's reference, Ed1 pg 488
        (description of name() function) which recommends local-name() -
        the output document is correct, but the prefix is gratuitously
        removed.
     -->
         <xsl:element name="{name()}" namespace="{namespace-uri()}">
            <xsl:copy-of select="@*"/>
            <xsl:apply-templates select="node()"/>
         </xsl:element>
</xsl:template>

<xsl:template match="comment()|processing-instruction()" priority="-1">
   <xsl:copy/>
</xsl:template>

<xsl:template match="*" priority="-1" mode="source" name="source-mode">
   <xsl:text/>&lt;<xsl:value-of select="name()"/>
   <xsl:apply-templates select="@*" mode="source"/>
   <xsl:choose>
      <xsl:when test="node()">
         <!-- non-empty element: do the content and a full end tag -->
         <xsl:text>&gt;</xsl:text>
         <xsl:apply-templates select="node()" mode="source"/>
         <xsl:text/>&lt;/<xsl:value-of select="name()"/>&gt;<xsl:text/>
      </xsl:when>
      <xsl:otherwise>
         <!-- empty element: do a short end tag -->
         <xsl:text>/&gt;</xsl:text>
      </xsl:otherwise>
   </xsl:choose>
</xsl:template>

<xsl:template match="@*" mode="source" priority="-1">
   <xsl:text> </xsl:text>
   <xsl:value-of select="name()"/>
   <xsl:text>="</xsl:text>
   <xsl:value-of select="."/>
   <xsl:text>"</xsl:text>
</xsl:template>

<xsl:template match="comment()" mode="source" priority="-1">
   <xsl:text/>&lt;!--<xsl:value-of select="."/>--&gt;<xsl:text/>
</xsl:template>

<xsl:template match="processing-instruction()" mode="source" priority="-1">
   <xsl:text>&lt;?</xsl:text>
   <xsl:value-of select="name()"/>
   <xsl:text> </xsl:text>
   <xsl:value-of select="."/>
   <xsl:text>?&gt;</xsl:text>
</xsl:template>

<xsl:template match="m21:presentation">
   <xsl:variable name="file" select="substring-after (saxon:systemId(), '/')"/>
   <xsl:variable name="label">
      <xsl:text>Object </xsl:text><xsl:value-of select="../@name"/>
      <xsl:text> presentation:</xsl:text><xsl:value-of select="@match"/>
   </xsl:variable>
   <m21:xref file="{$file}" line="{saxon:lineNumber()}" label="{$label}">
      <programlisting>
         <xsl:apply-templates select="." mode="source"/>
      </programlisting>
   </m21:xref>
</xsl:template>


</xsl:transform>