<?xml version="1.0" encoding="utf-8"?>
<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m21="http://melvaig.com/m21" xmlns:mapper="java:com.melvaig.java.io.PathMapper" exclude-result-prefixes="m21 mapper" version="1.1">

<xsl:import href="http://nwalsh.com/docbook/xsl/html/docbook.xsl"/>


<xsl:param name="m21.dir" select="'.'"/>

<xsl:param name="html.stylesheet" select="concat($m21.dir, '/m21-html.css')"/>

<xsl:param name="toc.section.depth" select="4"/>

<xsl:param name="use.extensions" select="1"/>

<xsl:param name="m21.mapper"/>

<xsl:template match="m21:xref">
   <xsl:param name="suppress-numbers" select="'0'"/>
   <xsl:variable name="file" select="mapper:toRelativePath($m21.mapper, @file)"/>
   <div class="m21code" onmouseover="window.status=&#34;{$file}:{@line}&#34;;" onmouseout="window.status=&#34;&#34;;">
      <div class="m21label">
         <img class="m21edit" src="{$m21.dir}/m21-edit-drag.gif" file="{$file}" line="{@line}" onDragStart="fOnDragStart();"/>
         <xsl:if test="@label">
            <xsl:text> For </xsl:text>
            <xsl:value-of select="@label"/>
         </xsl:if>
      </div>
      <xsl:apply-templates>
         <xsl:with-param name="suppress-numbers" select="$suppress-numbers"/>
      </xsl:apply-templates>
   </div>
</xsl:template>

<xsl:template name="user.head.content">
  <xsl:param name="node" select="."/>
   <SCRIPT TYPE="text/javascript" LANGUAGE="JavaScript">

   function fGoToLine(obj) {
      return "&lt;xref xmlns='http://melvaig.com/m21' base='"
               +document.URL+"' file='"
               +obj.file+"' line='"+obj.line+"'/&gt;"
   }

   function fOnDragStart() {
      obj = window.event.srcElement

      if (obj.className == "m21edit") {

         if (!window.event.dataTransfer) {

            alert("This version of IE does not support Drag and Drop")
            return
         }
         window.event.dataTransfer.clearData(); // remove image information
         window.event.dataTransfer.setData("Text", fGoToLine(obj));
	 window.event.dataTransfer.effectAllowed="copy";
      }
   }

</SCRIPT>
</xsl:template>


</xsl:transform>