/*
 * Decompiled with CFR 0.152.
 */
package com.melvaig.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class JarParser
implements Locator,
XMLReader {
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private String systemId;
    private AttributesImpl emptyAttList = new AttributesImpl();
    private AttributesImpl attList = new AttributesImpl();

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setLocale(Locale locale) {
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/features/namespaces".equals(string) || "http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            return;
        }
        throw new SAXNotRecognizedException("JarParser does not recognize requested feature");
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/features/namespaces".equals(string)) {
            return true;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(string)) {
            return false;
        }
        throw new SAXNotRecognizedException("JarParser does not recognize requested feature");
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException("JarParser does not recognize any properties");
    }

    public Object getProperty(String string) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException("JarParser does not recognize any properties");
    }

    public void parse(String string) throws SAXException, IOException {
        this.systemId = string;
        this.parse(new URL(string).openStream());
    }

    public void parse(InputSource inputSource) throws SAXException, IOException {
        this.systemId = inputSource.getSystemId();
        if (inputSource.getByteStream() != null) {
            this.parse(inputSource.getByteStream());
        } else if (this.systemId != null) {
            this.parse(this.systemId);
        } else {
            throw new SAXException("Could not read input supplied");
        }
    }

    private void parse(InputStream inputStream) throws SAXException, IOException {
        JarInputStream jarInputStream = new JarInputStream(inputStream, false);
        if (this.contentHandler == null) {
            this.contentHandler = new DefaultHandler();
        }
        if (this.errorHandler == null) {
            this.errorHandler = new DefaultHandler();
        }
        this.contentHandler.setDocumentLocator(this);
        this.contentHandler.startDocument();
        this.contentHandler.startElement("", "JarContent", "JarContent", this.emptyAttList);
        try {
            try {
                JarEntry jarEntry = jarInputStream.getNextJarEntry();
                while (jarEntry != null) {
                    String string;
                    String string2 = jarEntry.getName();
                    if (jarEntry.isDirectory()) {
                        string = "Dir";
                        this.contentHandler.startElement("", string, string, this.emptyAttList);
                    } else {
                        string = "File";
                        this.attList.clear();
                        int n = string2.lastIndexOf(47);
                        if (n > 0) {
                            String string3 = string2.substring(0, n);
                            this.attList.addAttribute("", "dir", "dir", "CDATA", string3);
                            string2 = string2.substring(n + 1);
                        }
                        String string4 = (n = string2.lastIndexOf(46)) > 0 ? string2.substring(n + 1) : "";
                        this.attList.addAttribute("", "ext", "ext", "CDATA", string4);
                        this.contentHandler.startElement("", string, string, this.attList);
                    }
                    this.contentHandler.characters(string2.toCharArray(), 0, string2.length());
                    this.contentHandler.endElement("", string, string);
                    jarEntry = jarInputStream.getNextJarEntry();
                }
            }
            catch (SAXException sAXException) {
                SAXParseException sAXParseException = new SAXParseException(sAXException.getMessage(), this);
                this.errorHandler.fatalError(sAXParseException);
                throw sAXParseException;
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            jarInputStream.close();
            throw throwable;
        }
        jarInputStream.close();
        this.contentHandler.endElement("", "JarContent", "JarContent");
        this.contentHandler.endDocument();
    }
}

