/*
 * Decompiled with CFR 0.152.
 */
package com.melvaig.m21;

import com.melvaig.m21.EditGoTo;
import com.melvaig.m21.M21CommandInitialise;
import com.melvaig.m21.M21CommandProcess;
import com.melvaig.m21.M21HelpAbout;
import com.melvaig.m21.M21HelpLicensee;
import com.melvaig.m21.M21Processor;
import com.melvaig.m21.M21ResponseInitialized;
import com.melvaig.m21.M21ResponseProcessed;
import com.melvaig.xml.GUIErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class M21UserInterface
extends JPanel
implements DropTargetListener {
    private JFrame frame;
    JMenuItem processMenuEntry = new JMenuItem("Run", 82);
    JButton processButton = new JButton("Run");
    JLabel specLabel = new JLabel("Initilizing...");
    JLabel dirLabel = new JLabel("Initilizing...");
    JCheckBoxMenuItem debugMenuEntry = new JCheckBoxMenuItem("Trace");
    private JCheckBox validate = new JCheckBox("Validate", false);
    private JCheckBox generate = new JCheckBox("Generate", true);
    private JCheckBox weave = new JCheckBox("HTML", true);
    JMenuItem quitMenuEntry = new JMenuItem("Exit", 88);
    private M21Processor m21;
    JMenuItem aboutMenuEntry = new JMenuItem("About", 65);
    private M21HelpAbout helpAbout = null;
    JMenuItem licenseeMenuEntry = new JMenuItem("Licensee", 76);
    private M21HelpLicensee helpLicensee = null;
    public File specFile = null;
    private JFileChooser defaultFileChooser = new JFileChooser(new File("."));
    JMenuItem openMenuEntry = new JMenuItem("Open", 79);
    private DropTarget dropTarget = new DropTarget(this, this);
    public File outDir = null;
    private JFileChooser dirFileChooser = new JFileChooser(new File("."));
    JMenuItem selectDirMenuEntry = new JMenuItem("Choose...", 67);
    JMenuItem defaultDirMenuEntry = new JMenuItem("Use Default", 68);

    M21UserInterface(M21Processor m21Processor, File file, File file2) {
        Object object;
        Container container;
        JComponent jComponent;
        Object object2;
        this.m21 = m21Processor;
        this.frame = new JFrame("Sock");
        this.processMenuEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                M21UserInterface.this.processAction();
            }
        });
        this.processButton.setMnemonic('R');
        this.processButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                M21UserInterface.this.processAction();
            }
        });
        this.debugMenuEntry.setMnemonic(84);
        this.debugMenuEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (M21UserInterface.this.debugMenuEntry.getState()) {
                    M21UserInterface.this.debugSet();
                } else {
                    M21UserInterface.this.debugClear();
                }
            }
        });
        JTextArea jTextArea = new JTextArea(6, 50);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        EditGoTo editGoTo = new EditGoTo("Edit", m21Processor);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        if (M21Processor.isLicensed()) {
            jTextArea.setText("Sock 0.9.2\nCopyright (c) 2002 Melvaig Software Engineering Limited  All Rights Reserved\n" + M21Processor.getLicenceText());
        } else {
            jTextArea.setText("Sock 0.9.2\nCopyright (c) 2002 Melvaig Software Engineering Limited  All Rights Reserved\nThis is an unlicensed copy, available for evaluation purposes only\n");
            boolean bl = false;
            object2 = new String[]{"Accept", "Decline"};
            jComponent = new JOptionPane(M21HelpLicensee.makeDisplay(), -1, 0, null, (Object[])object2);
            container = ((JOptionPane)jComponent).createDialog(jTextArea, "Evaluation Copy");
            container.setSize(400, 500);
            ((Window)container).setLocationRelativeTo(null);
            ((Dialog)container).show();
            object = ((JOptionPane)jComponent).getValue();
            if (object != null && object instanceof String) {
                boolean bl2 = bl = object == object2[0];
            }
            if (!bl) {
                System.exit(0);
            }
        }
        this.m21.setLogger(new GUIErrorLogger(jTextArea));
        this.processSetEnabled(false);
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.m21.doCommand(new M21CommandInitialise(), new M21ResponseInitialized(this));
        this.quitMenuEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                M21UserInterface.this.quitAction();
            }
        });
        JMenuBar jMenuBar = new JMenuBar();
        object2 = new JMenu("File");
        ((AbstractButton)object2).setMnemonic(70);
        ((JMenu)object2).add(this.openMenuEntry);
        ((JMenu)object2).add(this.processMenuEntry);
        ((JMenu)object2).addSeparator();
        ((JMenu)object2).add(this.quitMenuEntry);
        jMenuBar.add((JMenu)object2);
        jComponent = new JMenu("Tools");
        ((AbstractButton)jComponent).setMnemonic(84);
        container = new JMenu("Output Directory...");
        ((AbstractButton)container).setMnemonic(79);
        ((JMenu)container).add(this.selectDirMenuEntry);
        ((JMenu)container).add(this.defaultDirMenuEntry);
        ((JMenu)jComponent).add((JMenuItem)container);
        ((JMenu)jComponent).add(this.debugMenuEntry);
        jMenuBar.add((JMenu)jComponent);
        jMenuBar.add(Box.createHorizontalGlue());
        object = new JMenu("Help");
        ((AbstractButton)object).setMnemonic(72);
        ((JMenu)object).add(this.aboutMenuEntry);
        ((JMenu)object).add(this.licenseeMenuEntry);
        jMenuBar.add((JMenu)object);
        this.frame.setJMenuBar(jMenuBar);
        this.setLayout(new BorderLayout());
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(10));
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalStrut(20));
        box2.add(this.specLabel);
        box2.add(Box.createHorizontalGlue());
        box.add(box2);
        Box box3 = Box.createHorizontalBox();
        box3.add(Box.createHorizontalStrut(20));
        box3.add(this.dirLabel);
        box3.add(Box.createHorizontalGlue());
        box.add(box3);
        Box box4 = Box.createHorizontalBox();
        box4.add(Box.createHorizontalStrut(20));
        box4.add(this.validate);
        box4.add(Box.createHorizontalGlue());
        box.add(box4);
        Box box5 = Box.createHorizontalBox();
        box5.add(Box.createHorizontalStrut(20));
        box5.add(this.generate);
        box5.add(Box.createHorizontalGlue());
        box.add(box5);
        Box box6 = Box.createHorizontalBox();
        box6.add(Box.createHorizontalStrut(20));
        box6.add(this.weave);
        box6.add(Box.createHorizontalGlue());
        box.add(box6);
        Box box7 = Box.createHorizontalBox();
        box7.add(Box.createHorizontalStrut(20));
        box7.add(this.processButton);
        box7.add(Box.createHorizontalGlue());
        box.add(box7);
        box.add(Box.createVerticalStrut(10));
        this.add((Component)box, "North");
        this.add((Component)jScrollPane, "Center");
        this.add((Component)editGoTo, "South");
        this.specFile = file;
        this.outDir = file2;
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                M21UserInterface.this.quitAction();
            }
        });
        this.aboutMenuEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                M21UserInterface.this.aboutAction();
            }
        });
        this.licenseeMenuEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                M21UserInterface.this.licenseeAction();
            }
        });
        this.openMenuEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                M21UserInterface.this.openAction();
            }
        });
        new DropTarget(this.specLabel, this);
        new DropTarget(this.processButton, this);
        new DropTarget(jTextArea, this);
        this.selectDirMenuEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                M21UserInterface.this.selectDirAction();
            }
        });
        this.defaultDirMenuEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                M21UserInterface.this.defaultDirAction();
            }
        });
        new DropTarget(this.dirLabel, this);
        this.frame.getContentPane().add("Center", this);
        this.frame.pack();
        ((Component)this.frame).setVisible(true);
    }

    private void processSetEnabled(boolean bl) {
        this.processMenuEntry.setEnabled(bl);
        this.processButton.setEnabled(bl);
    }

    private void processAction() {
        this.processSetEnabled(false);
        this.frame.setCursor(Cursor.getPredefinedCursor(3));
        this.m21.logReset();
        this.m21.doCommand(new M21CommandProcess(this.specFile, this.outDir, this.validate.isSelected(), this.generate.isSelected(), this.weave.isSelected()), new M21ResponseProcessed(this));
    }

    private void debugSetEnabled(boolean bl) {
        this.debugMenuEntry.setEnabled(bl);
    }

    private void debugSet() {
        M21Processor.setTrace(true);
        M21Processor.trace("Trace starts.");
    }

    private void debugClear() {
        M21Processor.trace("Trace ends.");
        M21Processor.setTrace(false);
    }

    private void quitSetEnabled(boolean bl) {
        this.quitMenuEntry.setEnabled(bl);
    }

    private void quitAction() {
        System.exit(0);
    }

    void initialised() {
        this.setSpecification(this.specFile);
        this.setOutputDirectory(this.outDir);
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    void processed() {
        this.processSetEnabled(true);
        this.frame.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void aboutSetEnabled(boolean bl) {
        this.aboutMenuEntry.setEnabled(bl);
    }

    private void aboutAction() {
        if (this.helpAbout == null) {
            this.helpAbout = new M21HelpAbout();
        } else {
            this.helpAbout.makeVisible();
        }
    }

    private void licenseeSetEnabled(boolean bl) {
        this.licenseeMenuEntry.setEnabled(bl);
    }

    private void licenseeAction() {
        if (this.helpLicensee == null) {
            this.helpLicensee = new M21HelpLicensee();
        } else {
            this.helpLicensee.makeVisible();
        }
    }

    private void setSpecification(File file) {
        if (file == null) {
            this.frame.setTitle("Sock: None");
            this.specFile = null;
            this.specLabel.setText("No specification selected");
            this.processSetEnabled(false);
            return;
        }
        if (file.canRead() && !file.isDirectory()) {
            this.frame.setTitle("Sock: " + file.getName());
            this.specFile = file;
            this.specLabel.setText(file.toString());
            M21Processor.setTraceDirectory(file.getParentFile());
            this.processSetEnabled(true);
        } else {
            M21Processor.trace("Cannot open " + file.getName());
            this.m21.logReset();
            this.m21.logMessage("Cannot read '" + file.toString() + "'");
        }
    }

    private void openSetEnabled(boolean bl) {
        this.openMenuEntry.setEnabled(bl);
    }

    private void openAction() {
        int n = this.defaultFileChooser.showOpenDialog(this.frame);
        if (n == 0) {
            this.setSpecification(this.defaultFileChooser.getSelectedFile());
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.getFlavour(dropTargetDragEvent.getCurrentDataFlavors()) == null) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor dataFlavor = this.getFlavour(transferable.getTransferDataFlavors());
            if (dataFlavor != null) {
                dropTargetDropEvent.acceptDrop(1);
                bl = true;
                List list = (List)transferable.getTransferData(dataFlavor);
                File file = (File)list.get(0);
                if (file.isDirectory()) {
                    this.setOutputDirectory(file);
                } else {
                    this.setSpecification(file);
                }
                M21Processor.trace("m21ui drop file: dragAccept" + file.toString());
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                M21Processor.trace("m21ui drop file: dragReject");
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("Exception" + iOException.getMessage());
            if (bl) {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            System.err.println("Exception" + unsupportedFlavorException.getMessage());
            if (bl) {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            }
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private DataFlavor getFlavour(DataFlavor[] dataFlavorArray) {
        int n = 0;
        while (n < dataFlavorArray.length) {
            M21Processor.trace("m21ui drop file: offered " + dataFlavorArray[n].getHumanPresentableName());
            if (dataFlavorArray[n].isFlavorJavaFileListType()) {
                M21Processor.trace("m21ui drop file: isFile");
                return dataFlavorArray[n];
            }
            ++n;
        }
        return null;
    }

    private void setOutputDirectory(File file) {
        if (file == null) {
            this.outDir = null;
            this.dirLabel.setText("Output files relative to specification");
            return;
        }
        if (file.isDirectory()) {
            this.outDir = file;
            this.dirLabel.setText("Output files relative to " + file.toString());
            M21Processor.setTraceDirectory(file);
        } else {
            M21Processor.trace("Not a directory: " + file.getName());
            this.m21.logReset();
            this.m21.logMessage("'" + file.toString() + "' is not a directory");
        }
    }

    private void selectDirSetEnabled(boolean bl) {
        this.selectDirMenuEntry.setEnabled(bl);
    }

    private void selectDirAction() {
        this.dirFileChooser.setFileSelectionMode(1);
        int n = this.dirFileChooser.showOpenDialog(this.frame);
        if (n == 0) {
            this.setOutputDirectory(this.dirFileChooser.getSelectedFile());
        }
    }

    private void defaultDirSetEnabled(boolean bl) {
        this.defaultDirMenuEntry.setEnabled(bl);
    }

    private void defaultDirAction() {
        this.setOutputDirectory(null);
    }
}

