/*
 * Decompiled with CFR 0.152.
 */
package com.melvaig.m21;

import com.melvaig.m21.M21Processor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public class M21Resource {
    private static M21Resource sharedInstance = null;
    private static String instDir = null;

    private M21Resource() {
    }

    static M21Resource instance() {
        if (sharedInstance == null) {
            sharedInstance = new M21Resource();
        }
        return sharedInstance;
    }

    InputStream getResourceAsStream(String string) {
        return this.getClass().getResourceAsStream(string);
    }

    InputStream getFileAsStream(String string, boolean bl) {
        try {
            URL uRL = this.getFile(string, bl);
            if (uRL == null) {
                return null;
            }
            return uRL.openStream();
        }
        catch (IOException iOException) {
            M21Processor.trace("getFileAsStream: " + iOException.toString());
            return null;
        }
    }

    URL getFile(String string, boolean bl) {
        Object object;
        if (bl) {
            try {
                M21Processor.trace("getResource getFile " + string);
                object = new File(string);
                M21Processor.trace("getResource getFile File= " + ((File)object).getAbsolutePath());
                if (((File)object).isFile() && ((File)object).canRead()) {
                    return ((File)object).toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new Error("getResource unexpected exception " + malformedURLException.toString());
            }
        }
        try {
            URL uRL = new URL(this.getInstDir() + string);
            object = uRL.openStream();
            ((InputStream)object).close();
            return uRL;
        }
        catch (FileNotFoundException fileNotFoundException) {
            M21Processor.trace("getResource " + fileNotFoundException.toString());
        }
        catch (Exception exception) {
            throw new Error("getResource unexpected exception " + exception.toString());
        }
        return this.getResource(string);
    }

    URL getResource(String string) {
        URL uRL = this.getClass().getResource(string);
        M21Processor.trace("getResource ='" + (uRL == null ? "null" : uRL.toString()) + "'");
        return uRL;
    }

    Source getFileAsSource(String string) throws IOException {
        return this.getFileAsSource(string, false);
    }

    Source getFileAsSource(String string, boolean bl) throws IOException {
        URL uRL = this.getFile(string, bl);
        if (uRL == null) {
            return null;
        }
        SAXSource sAXSource = new SAXSource();
        InputSource inputSource = new InputSource(uRL.openStream());
        sAXSource.setInputSource(inputSource);
        sAXSource.setSystemId(uRL.toString());
        return sAXSource;
    }

    Result getFileAsResult(String string) {
        return new StreamResult(this.getInstDir() + string);
    }

    String getInstDir() {
        if (instDir != null) {
            return instDir;
        }
        URL uRL = this.getResource("m21core.xsl");
        if (uRL == null) {
            throw new Error("M21 installation problem 'm21core.xsl' not found");
        }
        String string = uRL.toString();
        if (string.startsWith("jar:")) {
            if (string.endsWith("/sock.jar!/com/melvaig/m21/m21core.xsl")) {
                instDir = string.substring("jar:".length(), string.length() - "/sock.jar!/com/melvaig/m21/m21core.xsl".length() + 1);
            }
        } else if (string.startsWith("file:") && string.endsWith("/com/melvaig/m21/m21core.xsl")) {
            instDir = string.substring(0, string.length() - "/com/melvaig/m21/m21core.xsl".length() + 1);
        }
        if (instDir == null) {
            throw new Error("Sock installation problem url='" + string + "'");
        }
        M21Processor.trace("dir='" + instDir + "'");
        return instDir;
    }
}

