/*
 * Decompiled with CFR 0.152.
 */
package com.melvaig.m21;

import com.icl.saxon.TransformerFactoryImpl;
import com.melvaig.java.io.PathMapper;
import com.melvaig.m21.M21Command;
import com.melvaig.m21.M21Resource;
import com.melvaig.m21.M21URIResolver;
import com.melvaig.m21.M21UserInterface;
import com.melvaig.m21.Tracer;
import com.melvaig.m21.Version;
import com.melvaig.m21.XMLElement;
import com.melvaig.xml.ErrorLogger;
import com.melvaig.xml.PrintErrorLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import javax.swing.SwingUtilities;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class M21Processor
implements Runnable,
Version {
    public Templates doGoTo;
    private M21URIResolver resolver;
    private TransformerFactory tfactory;
    private Templates analyse;
    private M21Command command;
    private Runnable onCompletion;
    private ErrorLogger log;
    private File currentSpec;
    private File currentM21Directory;
    private boolean validateOk;
    M21Resource finder;
    private static String licence = null;
    private static String licenceDisplay = null;
    private static String licenceHtml = null;
    private static String licenceText = null;
    private static boolean isLicensed = false;
    private static boolean trace = false;
    private static Tracer tracer = new Tracer();
    private Transformer copyXML;

    public TransformerFactory tfactory() {
        if (this.tfactory == null) {
            this.tfactory = TransformerFactory.newInstance();
            this.resolver = new M21URIResolver();
            this.tfactory.setURIResolver(this.resolver);
            ((TransformerFactoryImpl)this.tfactory).setOutputURIResolver(this.resolver);
            this.tfactory.setAttribute("http://icl.com/saxon/feature/linenumbering", new Boolean(true));
        }
        return this.tfactory;
    }

    public M21Processor() {
        block6: {
            this.command = null;
            this.onCompletion = null;
            this.finder = M21Resource.instance();
            try {
                this.copyXML = this.tfactory().newTransformer(this.finder.getFileAsSource("/com/melvaig/xml/pretty.xsl"));
                Transformer transformer = this.tfactory().newTransformer(this.finder.getFileAsSource("m21ParseOptions.xsl"));
                DOMResult dOMResult = new DOMResult();
                transformer.setParameter("home", this.finder.getInstDir().substring(6));
                transformer.transform(this.finder.getFileAsSource("sock.ini", true), dOMResult);
                this.doGoTo = this.tfactory.newTemplates(this.resolver.getResultAsSource("internal:editGoTo.xsl"));
                if (!trace) break block6;
                try {
                    this.copyXML.transform(new DOMSource(dOMResult.getNode()), new StreamResult(new FileOutputStream(M21Processor.newTraceFileName("_options_report.txt"))));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new Error(fileNotFoundException.toString());
                }
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                System.err.println("Constructor failure:" + transformerConfigurationException.toString());
                System.exit(1);
            }
            catch (TransformerException transformerException) {
                System.err.println("Constructor failure:" + transformerException.toString());
                System.exit(1);
            }
            catch (IOException iOException) {
                System.err.println("Constructor failure:" + iOException.toString());
                System.exit(1);
            }
        }
    }

    public void initialise() {
        try {
            this.analyse = this.tfactory().newTemplates(this.finder.getFileAsSource("m21analyse.xsl"));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            System.err.println("Initialisation failure:" + transformerConfigurationException.toString());
            System.exit(1);
        }
        catch (TransformerException transformerException) {
            System.err.println("Initialisation failure:" + transformerException.toString());
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("Initialisation failure:" + iOException.toString());
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        String string = "";
        File file = null;
        File file2 = null;
        boolean bl = false;
        try {
            int n = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                if (string2.startsWith("-")) {
                    if (string2.equals("-v") || string2.equals("--validate")) {
                        bl3 = true;
                        ++n;
                        continue;
                    }
                    if (string2.equals("-b") || string2.equals("--process")) {
                        bl4 = true;
                        ++n;
                        continue;
                    }
                    if (string2.equals("-h") || string2.equals("--html")) {
                        bl5 = true;
                        ++n;
                        continue;
                    }
                    if (string2.equals("-o") || string2.equals("--output")) {
                        if (n + 0 > stringArray.length) {
                            System.err.println("Missing argument for " + string2);
                            bl2 = true;
                        } else if (!(file2 = new File(string2 = stringArray[++n])).isDirectory()) {
                            System.err.println("'" + string2 + "' is not a directory");
                            file2 = null;
                            bl2 = true;
                        }
                        ++n;
                        continue;
                    }
                    if (string2.equals("-z") || string2.equals("--trace")) {
                        bl7 = true;
                        ++n;
                        continue;
                    }
                    if (string2.equals("-?") || string2.equals("--help")) {
                        bl8 = true;
                        ++n;
                        continue;
                    }
                    System.err.println("Illegal option: '" + string2 + "'");
                    bl2 = true;
                    ++n;
                    continue;
                }
                if (n + 1 != stringArray.length) {
                    System.err.println("Specification file must be the last argument");
                    bl2 = true;
                    break;
                }
                string = string2;
                ++n;
            }
            trace = bl7;
            if (string.length() != 0) {
                file = new File(string);
                if (file.isFile() && file.canRead()) {
                    file = file.getAbsoluteFile();
                    M21Processor.setTraceDirectory(file.getParentFile());
                } else {
                    System.err.println("'" + string + "' not readable");
                    bl2 = true;
                }
            }
            bl = bl4 || bl5 || bl3;
            boolean bl9 = bl2 = bl2 || bl && string.length() == 0;
            if (bl2 || bl8) {
                System.err.println("\nUsage:\n\nsock [options] [spec]\n  -v\n  --validate\n         validate 'spec'; exit with status 2 if errors are found\n  -b\n  --process\n         process 'spec'\n  -h\n  --html\n         produce DocBook HTML from 'spec'\n  -o dir\n  --output dir\n         place output files relative to 'dir'\n  -?\n  --help\n         Print this message and exit\n  -z\n  --trace\n         switch tracing on\n\nIf none of the above options are specified, sock starts\nwith a GUI.  'spec' may be given to preselect the\nspecification to work with, and the output directory\nmay be specified.\n\n\n");
            }
            if (bl2) {
                System.exit(1);
            }
            if (!M21Processor.checkLicence()) {
                M21Processor.trace("Licence not found");
                System.exit(1);
            }
            if (M21Processor.isLicensed()) {
                System.out.println("Sock 0.9.2\nCopyright (c) 2002 Melvaig Software Engineering Limited  All Rights Reserved\n" + M21Processor.getLicenceText());
            } else {
                System.out.println("Sock 0.9.2\nCopyright (c) 2002 Melvaig Software Engineering Limited  All Rights Reserved\nThis is an unlicensed copy, available for evaluation purposes only\n");
            }
            if (bl8) {
                System.exit(0);
            }
            M21Processor m21Processor = new M21Processor();
            if (bl) {
                m21Processor.setLogger(new PrintErrorLogger());
                m21Processor.initialise();
                if (bl3 && !m21Processor.validate(file)) {
                    System.exit(2);
                }
                if (bl4 || bl5) {
                    m21Processor.analyse(file);
                }
                if (bl4) {
                    m21Processor.process(file, file2);
                }
                if (bl5) {
                    m21Processor.toHTML(file);
                }
            } else {
                Thread thread = new Thread(m21Processor);
                thread.setDaemon(true);
                thread.start();
                M21UserInterface m21UserInterface = new M21UserInterface(m21Processor, file, file2);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Abnormal Termination:" + throwable.toString());
            PrintStream printStream = M21Processor.newTraceFile("sock_problem.skd");
            printStream.println("Exception: " + throwable.toString());
            throwable.printStackTrace(printStream);
            printStream.close();
            System.exit(1);
        }
    }

    public synchronized void doCommand(M21Command m21Command, Runnable runnable) {
        M21Processor.trace("Receive command " + m21Command.toString());
        this.command = m21Command;
        this.onCompletion = runnable;
        this.notify();
    }

    public synchronized void run() {
        boolean bl;
        do {
            if (this.command == null) {
                M21Processor.trace("Waiting for command");
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new Error("Unexpected interrupt " + interruptedException.toString());
                }
                M21Processor.trace("Waiting for command - done");
            }
            bl = this.command.run(this);
            this.command = null;
            if (this.onCompletion == null) continue;
            SwingUtilities.invokeLater(this.onCompletion);
        } while (bl);
    }

    public void setLogger(ErrorLogger errorLogger) {
        this.log = errorLogger;
    }

    public void logMessage(String string) {
        this.log.log(string);
    }

    public void logReset() {
        this.log.clear();
    }

    private File getM21Directory(File file) {
        if (file != this.currentSpec) {
            boolean bl = false;
            File file2 = file.getParentFile();
            String string = file.getName();
            int n = string.lastIndexOf(46);
            if (n != -1) {
                string = string.substring(0, n);
            }
            string = string.concat(".m21");
            this.currentM21Directory = new File(file2, string);
            bl = !this.currentM21Directory.exists() ? this.currentM21Directory.mkdir() : this.currentM21Directory.isDirectory();
            if (!bl) {
                this.currentM21Directory = null;
                throw new Error("Could not create directory '" + string + "'");
            }
            this.currentSpec = file;
        }
        return this.currentM21Directory;
    }

    public boolean validate(File file) throws TransformerException, TransformerConfigurationException, IOException {
        String string;
        File file2;
        File file3 = file.getParentFile();
        PathMapper pathMapper = new PathMapper(file3);
        File file4 = this.getM21Directory(file);
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if ((file2 = new File(file3, string = string2.concat("-report.html"))).exists() && !file2.canWrite()) {
            System.err.println("Cannot write/create '" + string + "'");
            return false;
        }
        this.override(file4, "m21-edit-drag.gif", "m21-edit-drag.gif");
        this.override(file4, "m21-html.css", "m21-html.css");
        this.logMessage("validate...");
        this.resolver.getMap().clear();
        Transformer transformer = this.tfactory().newTransformer(this.finder.getFileAsSource("m21-sch-html.xsl"));
        this.validateOk = true;
        transformer.setParameter("m21", this);
        transformer.setParameter("m21.mapper", pathMapper);
        transformer.setParameter("m21.dir", file4.getName());
        transformer.setErrorListener(this.log);
        transformer.transform(new StreamSource(file), new StreamResult(file2));
        if (this.validateOk) {
            this.logMessage("done.");
        } else {
            this.logMessage("done, with errors.");
        }
        return this.validateOk;
    }

    public void validationFail() {
        this.validateOk = false;
        M21Processor.trace("validate reports Fail");
    }

    public void analyse(File file) throws TransformerException, TransformerConfigurationException {
        File file2 = this.getM21Directory(file);
        Transformer transformer = this.analyse.newTransformer();
        this.logMessage("analyse...");
        this.resolver.getMap().clear();
        transformer.setErrorListener(this.log);
        transformer.setParameter("m21.dir", file2.getAbsolutePath());
        transformer.transform(new StreamSource(file), new StreamResult(System.out));
    }

    public void process(File file, File file2) throws TransformerException, TransformerConfigurationException {
        DOMResult dOMResult = new DOMResult();
        String string = file2 == null ? file.getParent() : file2.getAbsolutePath();
        M21Processor.trace("Using '" + string + "' for output");
        if (trace) {
            try {
                this.copyXML.transform(this.resolver.getResultAsSource("internal:expandSpec"), new StreamResult(new FileOutputStream(M21Processor.newTraceFileName("_analyse.xsl"))));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Error(fileNotFoundException.toString());
            }
        }
        if (trace) {
            try {
                this.copyXML.transform(this.resolver.getResultAsSource("internal:generateSpec"), new StreamResult(new FileOutputStream(M21Processor.newTraceFileName("_generate.xsl"))));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Error(fileNotFoundException.toString());
            }
        }
        this.logMessage("expand...");
        Transformer transformer = this.tfactory().newTransformer(this.resolver.getResultAsSource("internal:expandSpec"));
        transformer.transform(new StreamSource(file), dOMResult);
        if (trace) {
            try {
                this.copyXML.transform(new DOMSource(dOMResult.getNode()), new StreamResult(new FileOutputStream(M21Processor.newTraceFileName("_replaced.xml"))));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Error(fileNotFoundException.toString());
            }
        }
        this.logMessage("generate...");
        Transformer transformer2 = this.tfactory().newTransformer(this.resolver.getResultAsSource("internal:generateSpec"));
        transformer2.setParameter("out-dir", string + "/");
        transformer2.transform(new DOMSource(dOMResult.getNode()), new StreamResult(System.out));
        if (trace) {
            try {
                this.copyXML.transform(this.resolver.getResultAsSource("internal:_generated"), new StreamResult(new FileOutputStream(M21Processor.newTraceFileName("_generated.xml"))));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Error(fileNotFoundException.toString());
            }
        }
        this.logMessage("done.");
    }

    public void toHTML(File file) throws TransformerException, TransformerConfigurationException, IOException {
        String string;
        File file2;
        File file3 = file.getParentFile();
        PathMapper pathMapper = new PathMapper(file3);
        File file4 = this.getM21Directory(file);
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        if ((file2 = new File(file3, string = string2.concat(".html"))).exists() && !file2.canWrite()) {
            System.err.println("Cannot write/create '" + string + "'");
            return;
        }
        this.override(file4, "m21-edit-drag.gif", "m21-edit-drag.gif");
        this.override(file4, "m21-html.css", "m21-html.css");
        this.logMessage("weave...");
        if (trace) {
            try {
                this.copyXML.transform(this.resolver.getResultAsSource("internal:weaveSpec"), new StreamResult(new FileOutputStream(M21Processor.newTraceFileName("_weave.xsl"))));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Error(fileNotFoundException.toString());
            }
        }
        Transformer transformer = this.tfactory().newTransformer(this.resolver.getResultAsSource("internal:weaveSpec"));
        transformer.setErrorListener(this.log);
        transformer.transform(new StreamSource(file), this.resolver.resolveNew("internal:weave", null, null));
        if (trace) {
            try {
                this.copyXML.transform(this.resolver.getResultAsSource("internal:weave"), new StreamResult(new FileOutputStream(M21Processor.newTraceFileName("_weave.db"))));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new Error(fileNotFoundException.toString());
            }
        }
        Transformer transformer2 = this.tfactory().newTransformer(this.finder.getFileAsSource("db-html.xsl"));
        transformer2.setParameter("m21.mapper", pathMapper);
        transformer2.setParameter("m21.dir", file4.getName());
        transformer2.transform(this.resolver.getResultAsSource("internal:weave"), new StreamResult(file2));
        this.logMessage("done.");
    }

    private void override(File file, String string, String string2) throws IOException {
        int n;
        File file2 = new File(file, string);
        if (file2.exists()) {
            return;
        }
        InputStream inputStream = this.finder.getFileAsStream(string2, false);
        if (inputStream == null) {
            throw new Error("Cannot find default '" + string2 + "'");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        do {
            if ((n = inputStream.read(byArray)) <= 0) continue;
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        } while (n != -1);
    }

    public static String getLicenceDisplay() {
        return licenceDisplay;
    }

    public static String getLicenceText() {
        return licenceText;
    }

    public static boolean isLicensed() {
        return isLicensed;
    }

    private static boolean checkLicence() {
        Object object;
        InputStreamReader inputStreamReader;
        StringBuffer stringBuffer;
        PublicKey publicKey;
        M21Resource m21Resource = M21Resource.instance();
        byte[] byArray = new byte[]{48, -126, 1, -72, 48, -126, 1, 44, 6, 7, 42, -122, 72, -50, 56, 4, 1, 48, -126, 1, 31, 2, -127, -127, 0, -3, 127, 83, -127, 29, 117, 18, 41, 82, -33, 74, -100, 46, -20, -28, -25, -10, 17, -73, 82, 60, -17, 68, 0, -61, 30, 63, -128, -74, 81, 38, 105, 69, 93, 64, 34, 81, -5, 89, 61, -115, 88, -6, -65, -59, -11, -70, 48, -10, -53, -101, 85, 108, -41, -127, 59, -128, 29, 52, 111, -14, 102, 96, -73, 107, -103, 80, -91, -92, -97, -97, -24, 4, 123, 16, 34, -62, 79, -69, -87, -41, -2, -73, -58, 27, -8, 59, 87, -25, -58, -88, -90, 21, 15, 4, -5, -125, -10, -45, -59, 30, -61, 2, 53, 84, 19, 90, 22, -111, 50, -10, 117, -13, -82, 43, 97, -41, 42, -17, -14, 34, 3, 25, -99, -47, 72, 1, -57, 2, 21, 0, -105, 96, 80, -113, 21, 35, 11, -52, -78, -110, -71, -126, -94, -21, -124, 11, -16, 88, 28, -11, 2, -127, -127, 0, -9, -31, -96, -123, -42, -101, 61, -34, -53, -68, -85, 92, 54, -72, 87, -71, 121, -108, -81, -69, -6, 58, -22, -126, -7, 87, 76, 11, 61, 7, -126, 103, 81, 89, 87, -114, -70, -44, 89, 79, -26, 113, 7, 16, -127, -128, -76, 73, 22, 113, 35, -24, 76, 40, 22, 19, -73, -49, 9, 50, -116, -56, -90, -31, 60, 22, 122, -117, 84, 124, -115, 40, -32, -93, -82, 30, 43, -77, -90, 117, -111, 110, -93, 127, 11, -6, 33, 53, 98, -15, -5, 98, 122, 1, 36, 59, -52, -92, -15, -66, -88, 81, -112, -119, -88, -125, -33, -31, 90, -27, -97, 6, -110, -117, 102, 94, -128, 123, 85, 37, 100, 1, 76, 59, -2, -49, 73, 42, 3, -127, -123, 0, 2, -127, -127, 0, -123, 59, 98, -31, -74, 5, 15, -77, 78, -124, 40, -27, -54, -23, 3, 68, -24, -46, 98, -8, 36, -35, -79, -1, 0, 29, 97, -33, -48, -66, 45, 38, -124, -106, -99, -43, -25, -65, -3, 100, -104, -61, -55, 125, -17, -88, 13, -39, 124, -93, 97, 28, -94, 122, 109, -16, 64, 26, -3, -48, 91, 110, -7, -70, -96, -116, 93, 109, 28, 21, 22, 49, -67, 14, 65, -118, 64, 117, 17, 63, 39, -128, 126, -96, -96, -35, 71, 27, 59, 102, 40, 30, 19, 94, 105, 32, 22, 51, -30, 24, -111, -112, -104, 109, 45, -36, -116, -53, 119, -27, -44, 52, 27, 116, -53, 112, -9, 79, -118, -63, -42, 99, 69, -47, -49, 20, -72, 69};
        byte[] byArray2 = new byte[]{48, 44, 2, 20, 28, 50, -104, -66, -128, 123, 25, -13, -9, -119, 60, -60, 111, -9, -9, 82, -43, -92, 126, 96, 2, 20, 41, 27, 119, -22, 122, -61, -120, 85, 47, 59, -79, -78, 14, 39, 67, -61, 5, 25, -4, 90};
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA", "SUN");
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new Error("key recovery: " + generalSecurityException.toString());
        }
        InputStream inputStream = m21Resource.getFileAsStream("doc/licence.html", false);
        try {
            int n;
            stringBuffer = new StringBuffer(1000);
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            do {
                if ((n = inputStreamReader.read()) <= 0) continue;
                stringBuffer.append((char)n);
            } while (n != -1);
            licenceDisplay = stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new Error("reading licence: " + iOException.toString());
        }
        try {
            object = Signature.getInstance("SHA1withDSA", "SUN");
            ((Signature)object).initVerify(publicKey);
            ((Signature)object).update(licenceDisplay.getBytes("UTF-8"));
            if (!((Signature)object).verify(byArray2)) {
                M21Processor.trace("bad html");
                return false;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            M21Processor.trace("HTML check: " + generalSecurityException.toString());
            return false;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            M21Processor.trace("HTML check: " + unsupportedEncodingException.toString());
            return false;
        }
        object = new XMLElement(licenceDisplay, "program-version");
        licenceDisplay = ((XMLElement)object).replace("0.9.2");
        if (licenceDisplay == null) {
            M21Processor.trace("bad html (1)");
            return false;
        }
        object = new XMLElement(licenceDisplay, "program-build");
        if ((licenceDisplay = ((XMLElement)object).replace("149")) == null) {
            M21Processor.trace("bad html (2)");
            return false;
        }
        object = new XMLElement(licenceDisplay, "program-date");
        if ((licenceDisplay = ((XMLElement)object).replace("2002/03/16")) == null) {
            M21Processor.trace("bad html (3)");
            return false;
        }
        inputStream = m21Resource.getFileAsStream("licence.dat", false);
        if (inputStream != null) {
            int n;
            object = new byte[2048];
            int n2 = 0;
            int n3 = 0;
            try {
                do {
                    if ((n = inputStream.read()) == -1) continue;
                    object[n2++] = (byte)n;
                } while (n != -1 && n2 < 2048);
            }
            catch (IOException iOException) {
                throw new Error("reading licence file: " + iOException.toString());
            }
            if (n != -1) {
                M21Processor.trace("bad licence (1)");
                return false;
            }
            n3 = 0;
            while (object[n3] != false) {
                ++n3;
            }
            int n4 = n3 + 1;
            byte[] byArray3 = new byte[n2 - n4];
            int n5 = 0;
            while (n5 < n2 - n4) {
                byArray3[n5] = (byte)object[n4 + n5];
                ++n5;
            }
            try {
                Signature signature = Signature.getInstance("SHA1withDSA", "SUN");
                signature.initVerify(publicKey);
                signature.update((byte[])object, 0, n3);
                if (!signature.verify(byArray3)) {
                    M21Processor.trace("bad licence (2)");
                    return false;
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                M21Processor.trace("signature check: " + generalSecurityException.toString());
                return false;
            }
            try {
                int n6;
                stringBuffer = new StringBuffer(1000);
                inputStreamReader = new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])object, 0, n3), "UTF-8");
                do {
                    if ((n6 = inputStreamReader.read()) <= 0) continue;
                    stringBuffer.append((char)n6);
                } while (n6 != -1);
                licence = stringBuffer.toString();
            }
            catch (IOException iOException) {
                throw new Error("reading licence: " + iOException.toString());
            }
            XMLElement xMLElement = new XMLElement(licence, "text");
            licenceText = xMLElement.content();
            if (licenceText == null) {
                M21Processor.trace("bad licence (3) '" + licence + "'");
                return false;
            }
            XMLElement xMLElement2 = new XMLElement(licence, "html");
            licenceHtml = xMLElement2.contentAsHTML();
            if (licenceHtml == null) {
                M21Processor.trace("bad licence (4) '" + licence + "'");
                return false;
            }
            XMLElement xMLElement3 = new XMLElement(licenceDisplay, "x");
            if ((licenceDisplay = xMLElement3.replace(licenceHtml)) == null) {
                M21Processor.trace("bad licence (5) '" + licence + "'");
                return false;
            }
            isLicensed = true;
            M21Processor.trace("licence='" + licence + "'");
            M21Processor.trace("licenceDisplay='" + licenceDisplay + "'");
        }
        return true;
    }

    public static boolean trace() {
        return trace;
    }

    public static void setTrace(boolean bl) {
        trace = bl;
    }

    public static void setTraceDirectory(File file) {
        tracer.setDirectory(file);
    }

    public static void trace(String string) {
        if (trace) {
            tracer.trace(string);
        }
    }

    public static PrintStream newTraceFile(String string) {
        return tracer.newTraceFile(string);
    }

    public static String newTraceFileName(String string) {
        return tracer.newTraceFileName(string);
    }
}

