/*
 * Decompiled with CFR 0.152.
 */
package com.melvaig.m21;

import com.melvaig.m21.M21Command;
import com.melvaig.m21.M21Processor;
import java.io.File;
import java.io.PrintStream;

class M21CommandProcess
extends M21Command {
    private File spec;
    private File outDir;
    private boolean validate;
    private boolean generate;
    private boolean html;

    protected boolean execute(M21Processor m21Processor) {
        try {
            if (this.validate && !m21Processor.validate(this.spec)) {
                return true;
            }
            if (this.generate || this.html) {
                m21Processor.analyse(this.spec);
            }
            if (this.generate) {
                m21Processor.process(this.spec, this.outDir);
            }
            if (this.html) {
                m21Processor.toHTML(this.spec);
            }
        }
        catch (Throwable throwable) {
            System.err.println("Abnormal Termination:" + throwable.toString());
            PrintStream printStream = M21Processor.newTraceFile("sock_problem.skd");
            printStream.println("Exception: " + throwable.toString());
            throwable.printStackTrace(printStream);
            printStream.close();
            m21Processor.logMessage(throwable.toString());
        }
        return true;
    }

    public M21CommandProcess(File file, File file2, boolean bl, boolean bl2, boolean bl3) {
        this.spec = file;
        this.outDir = file2;
        this.validate = bl;
        this.generate = bl2;
        this.html = bl3;
    }
}

