/*
 * Decompiled with CFR 0.152.
 */
package com.melvaig.m21;

import com.melvaig.java.io.TranslateFilter;
import com.melvaig.m21.M21Processor;
import com.melvaig.m21.M21Resource;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXParseException;

class EditGoTo
extends JButton
implements DropTargetListener {
    private DropTarget dropTarget = new DropTarget(this, this);
    M21Resource finder = M21Resource.instance();
    M21Processor m21;

    EditGoTo(String string, M21Processor m21Processor) {
        super(string);
        this.m21 = m21Processor;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.getFlavour(dropTargetDragEvent.getCurrentDataFlavors()) == null) {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        boolean bl = false;
        try {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor dataFlavor = this.getFlavour(transferable.getTransferDataFlavors());
            if (dataFlavor != null) {
                dropTargetDropEvent.acceptDrop(1);
                bl = true;
                Reader reader = dataFlavor.getReaderForText(transferable);
                StringWriter stringWriter = new StringWriter(200);
                this.m21.doGoTo.newTransformer().transform(new StreamSource(new TranslateFilter(reader, "\u0000", "")), new StreamResult(stringWriter));
                M21Processor.trace("Edit drop result=" + stringWriter.toString());
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                System.out.println("dragReject");
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("Exception" + iOException.getMessage());
            if (bl) {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
            System.err.println("Exception" + unsupportedFlavorException.getMessage());
            if (bl) {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            transformerConfigurationException.printStackTrace();
            System.err.println("Exception" + transformerConfigurationException.getMessage());
            if (bl) {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getCause();
            if (throwable instanceof SAXParseException) {
                this.m21.logMessage("Edit drop data not recognised\nDid you drag an edit icon?");
            } else {
                System.err.println("Cause: " + throwable.getMessage());
                transformerException.printStackTrace();
                System.err.println("Exception: " + transformerException.getMessage());
            }
            if (bl) {
                dropTargetDropEvent.getDropTargetContext().dropComplete(false);
            }
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private DataFlavor getFlavour(DataFlavor[] dataFlavorArray) {
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (dataFlavorArray[n].isRepresentationClassInputStream() && dataFlavorArray[n].isMimeTypeEqual("text/plain")) {
                return dataFlavorArray[n];
            }
            ++n;
        }
        return null;
    }
}

