/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.OutputURIResolver;
import com.icl.saxon.output.ContentHandlerProxy;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.XSLGeneralOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;

public class XSLDocument
extends XSLGeneralOutput {
    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        super.prepareAttributes();
        if (this.href == null) {
            this.reportAbsence("href");
        }
    }

    public void validate() throws TransformerConfigurationException {
        if (this.getURI().equals("http://www.w3.org/1999/XSL/Transform") && !this.forwardsCompatibleModeIsEnabled()) {
            this.compileError("To use xsl:document, set xsl:stylesheet version='1.1'");
        }
        this.checkWithinTemplate();
    }

    public void process(Context context) throws TransformerException {
        Object object;
        Object object2;
        Object object3;
        Controller controller = context.getController();
        Outputter outputter = controller.getOutputter();
        Properties properties = outputter.getOutputProperties();
        Properties properties2 = new Properties(properties);
        this.updateOutputProperties(properties2, context);
        Object object4 = null;
        String string = this.href.evaluateAsString(context);
        OutputURIResolver outputURIResolver = controller.getOutputURIResolver();
        object4 = outputURIResolver.resolveNew(string, null, properties2);
        if (object4 == null) {
            outputURIResolver = controller.getStandardOutputURIResolver();
            object4 = outputURIResolver.resolveNew(string, null, properties2);
        }
        if (this.nextInChain != null) {
            object3 = this.nextInChain.evaluateAsString(context);
            object2 = this.prepareNextStylesheet((String)object3, context);
            object = new ContentHandlerProxy();
            ((Emitter)object).setSystemId(this.getSystemId());
            ((ContentHandlerProxy)object).setUnderlyingContentHandler((ContentHandler)object2);
            ((ContentHandlerProxy)object).setRequireWellFormed(false);
            object2.setResult((Result)object4);
            object4 = object;
        }
        controller.changeOutputDestination(properties2, (Result)object4);
        this.processChildren(context);
        controller.resetOutputDestination(outputter);
        if (object4 instanceof StreamResult) {
            object3 = (StreamResult)object4;
            object2 = ((StreamResult)object3).getOutputStream();
            if (object2 != null) {
                try {
                    ((OutputStream)object2).close();
                }
                catch (IOException iOException) {
                    throw new TransformerException("Failed to close output file", iOException);
                }
            }
            object = ((StreamResult)object3).getWriter();
            if (object != null) {
                try {
                    ((Writer)object).close();
                }
                catch (IOException iOException) {
                    throw new TransformerException("Failed to close output file", iOException);
                }
            }
        }
    }
}

