/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.resolvers;

import com.icl.saxon.OutputURIResolver;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;

public class InternalURIResolver
implements OutputURIResolver,
URIResolver {
    private boolean trace = false;
    private Hashtable map = new Hashtable();

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public Map getMap() {
        return this.map;
    }

    public void putSource(String string, Source source) {
        this.map.put(string, source);
    }

    public Source getSource(String string) {
        Object v = this.map.get(string);
        if (v instanceof Source) {
            return (Source)v;
        }
        return null;
    }

    public void putResult(String string, Result result) {
        this.map.put(string, result);
    }

    public void putResult(String string) {
        DOMResult dOMResult = new DOMResult();
        dOMResult.setSystemId(string);
        this.map.put(string, dOMResult);
    }

    public Result getResult(String string) {
        Object v = this.map.get(string);
        if (v instanceof Result) {
            return (Result)v;
        }
        return null;
    }

    public Source getResultAsSource(String string) {
        Object v = this.map.get(string);
        if (v instanceof DOMResult) {
            DOMResult dOMResult = (DOMResult)v;
            return new DOMSource(dOMResult.getNode(), dOMResult.getSystemId());
        }
        return null;
    }

    public Result resolveNew(String string, String string2, Properties properties) throws TransformerException {
        Result result = this.getResult(string);
        if (result != null) {
            if (this.trace) {
                System.out.println("Output URI resolved: " + string);
            }
            return result;
        }
        if (!string.startsWith("internal:")) {
            return null;
        }
        DOMResult dOMResult = new DOMResult();
        dOMResult.setSystemId(string);
        this.map.put(string, dOMResult);
        if (this.trace) {
            System.out.println("Output URI created: " + string);
        }
        return dOMResult;
    }

    public Source resolve(String string, String string2) throws TransformerException {
        Source source = this.getSource(string);
        if (source != null) {
            if (this.trace) {
                System.out.println("URI resolved: " + string);
            }
            return source;
        }
        source = this.getResultAsSource(string);
        if (source != null) {
            if (this.trace) {
                System.out.println("URI resolved from output: " + string);
            }
            return source;
        }
        if (this.trace) {
            System.out.println("URI not resolved: " + string);
        }
        return null;
    }
}

