/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.charcode.CharacterSet;
import com.icl.saxon.charcode.CharacterSetFactory;
import com.icl.saxon.charcode.UnicodeCharacterSet;
import com.icl.saxon.output.Emitter;
import java.io.IOException;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class XMLEmitter
extends Emitter {
    protected CharacterSet characterSet = null;
    protected boolean empty = true;
    protected boolean escaping = true;
    protected boolean openStartTag = false;
    protected boolean declarationIsWritten = false;
    protected boolean preferHex = false;
    protected int lastNameCode = -1;
    protected String lastDisplayName;
    protected String lastPrefix;
    protected String lastURI;
    static boolean[] specialInText = new boolean[128];
    static boolean[] specialInAtt;
    char[] attbuff1 = new char[256];
    private char[] charref = new char[10];

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws TransformerException {
        if (this.characterSet == null) {
            this.characterSet = new UnicodeCharacterSet();
        }
        this.writeDeclaration();
        this.empty = true;
        String string = this.outputProperties.getProperty("{http://icl.com/saxon}character-representation");
        if (string != null) {
            this.preferHex = string.trim().equalsIgnoreCase("hex");
        }
    }

    public void writeDeclaration() throws TransformerException {
        if (this.declarationIsWritten) {
            return;
        }
        this.declarationIsWritten = true;
        try {
            String string;
            String string2;
            String string3 = this.outputProperties.getProperty("omit-xml-declaration");
            if (string3 == null) {
                string3 = "no";
            }
            if ((string2 = this.outputProperties.getProperty("version")) == null) {
                string2 = "1.0";
            }
            if ((string = this.outputProperties.getProperty("encoding")) == null || string.equalsIgnoreCase("utf8")) {
                string = "utf-8";
            }
            if (!string.equalsIgnoreCase("utf-8")) {
                string3 = "no";
            }
            String string4 = this.outputProperties.getProperty("standalone");
            if (string3.equals("no")) {
                this.writer.write("<?xml version=\"" + string2 + "\" " + "encoding=\"" + string + "\"" + (string4 != null ? " standalone=\"" + string4 + "\"" : "") + "?>");
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    protected void writeDocType(String string, String string2, String string3) throws TransformerException {
        try {
            this.writer.write("\n<!DOCTYPE " + string + "\n");
            if (string2 != null && string3 == null) {
                this.writer.write("  SYSTEM \"" + string2 + "\">\n");
            } else if (string2 == null && string3 != null) {
                this.writer.write("  PUBLIC \"" + string3 + "\">\n");
            } else {
                this.writer.write("  PUBLIC \"" + string3 + "\" \"" + string2 + "\">\n");
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void endDocument() throws TransformerException {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        String string;
        String string2;
        String string3;
        if (n == this.lastNameCode) {
            string3 = this.lastPrefix;
            string2 = this.lastURI;
            string = this.lastDisplayName;
        } else {
            string3 = this.namePool.getPrefix(n);
            string2 = this.namePool.getURI(n);
            string = this.namePool.getDisplayName(n);
            this.lastNameCode = n;
            this.lastDisplayName = string;
            this.lastPrefix = string3;
            this.lastURI = string2;
        }
        try {
            String string4;
            if (this.empty) {
                String string5 = this.outputProperties.getProperty("doctype-system");
                string4 = this.outputProperties.getProperty("doctype-public");
                if (string5 != null) {
                    this.writeDocType(string, string5, string4);
                }
                this.empty = false;
            }
            if (this.openStartTag) {
                this.closeStartTag(n, false);
            }
            this.writer.write(60);
            this.testCharacters(string);
            this.writer.write(string);
            int n3 = 0;
            while (n3 < n2) {
                this.writer.write(32);
                string4 = this.namePool.getPrefixFromNamespaceCode(nArray[n3]);
                String string6 = this.namePool.getURIFromNamespaceCode(nArray[n3]);
                if (string4.equals("")) {
                    this.writeAttribute(n, "xmlns", "CDATA", string6);
                } else {
                    this.writeAttribute(n, "xmlns:" + string4, "CDATA", string6);
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < attributes.getLength()) {
                this.writer.write(32);
                this.writeAttribute(n, attributes.getQName(n4), attributes.getType(n4), attributes.getValue(n4));
                ++n4;
            }
            this.openStartTag = true;
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    protected void closeStartTag(int n, boolean bl) throws TransformerException {
        try {
            if (this.openStartTag) {
                if (bl) {
                    this.writer.write(this.emptyElementTagCloser(n));
                } else {
                    this.writer.write(62);
                }
                this.openStartTag = false;
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    protected String emptyElementTagCloser(int n) {
        return "/>";
    }

    protected void writeAttribute(int n, String string, String string2, String string3) throws TransformerException {
        try {
            this.testCharacters(string);
            this.writer.write(string);
            this.writer.write("=\"");
            int n2 = string3.length();
            if (n2 > this.attbuff1.length) {
                this.attbuff1 = new char[n2];
            }
            string3.getChars(0, n2, this.attbuff1, 0);
            if (string2.equals("NO-ESC")) {
                this.writer.write(this.attbuff1, 0, n2);
            } else {
                this.writeEscape(this.attbuff1, 0, n2, true);
            }
            this.writer.write(34);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    protected void testCharacters(String string) throws TransformerException {
        int n = string.length() - 1;
        while (n >= 0) {
            if (!this.characterSet.inCharset(string.charAt(n))) {
                throw new TransformerException("Invalid character in output name (" + string + ")");
            }
            --n;
        }
    }

    protected boolean testCharacters(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (!this.characterSet.inCharset(cArray[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public void endElement(int n) throws TransformerException {
        try {
            if (this.openStartTag) {
                this.closeStartTag(n, true);
            } else {
                String string = n == this.lastNameCode ? this.lastDisplayName : this.namePool.getDisplayName(n);
                this.writer.write("</");
                this.writer.write(string);
                this.writer.write(62);
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        try {
            if (this.openStartTag) {
                this.closeStartTag(-1, false);
            }
            if (!this.escaping) {
                if (this.testCharacters(cArray, n, n2)) {
                    this.writer.write(cArray, n, n2);
                } else {
                    this.writeEscape(cArray, n, n2, false);
                }
            } else {
                this.writeEscape(cArray, n, n2, false);
            }
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void processingInstruction(String string, String string2) throws TransformerException {
        try {
            if (this.openStartTag) {
                this.closeStartTag(-1, false);
            }
            this.writer.write("<?" + string + (string2.length() > 0 ? ' ' + string2 : "") + "?>");
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    protected void writeEscape(char[] cArray, int n, int n2, boolean bl) throws IOException {
        int n3 = n;
        boolean[] blArray = bl ? specialInAtt : specialInText;
        while (n3 < n + n2) {
            boolean bl2;
            int n4 = n3;
            boolean bl3 = true;
            do {
                if (!bl3 || (bl3 = false) || !true) {
                    ++n4;
                }
                if (n4 >= n + n2) break;
                if (cArray[n4] < '\u0080') {
                    if (!blArray[cArray[n4]]) {
                        bl2 = true;
                        continue;
                    }
                    bl2 = false;
                    continue;
                }
                bl2 = this.characterSet.inCharset(cArray[n4]);
            } while (bl2);
            this.writer.write(cArray, n3, n4 - n3);
            if (n4 >= n + n2) {
                return;
            }
            if (cArray[n4] > '\u007f') {
                int n5;
                if (cArray[n4] >= '\ud800' && cArray[n4] <= '\udbff') {
                    n5 = (cArray[n4] - 55296) * 1024 + (cArray[n4 + 1] - 56320) + 65536;
                    ++n4;
                } else {
                    n5 = cArray[n4];
                }
                this.outputCharacterReference(n5);
            } else if (cArray[n4] == '<') {
                this.writer.write("&lt;");
            } else if (cArray[n4] == '>') {
                this.writer.write("&gt;");
            } else if (cArray[n4] == '&') {
                this.writer.write("&amp;");
            } else if (cArray[n4] == '\"') {
                this.writer.write("&#34;");
            } else if (cArray[n4] == '\n') {
                this.writer.write("&#xA;");
            }
            n3 = ++n4;
        }
    }

    protected void outputCharacterReference(int n) throws IOException {
        if (this.preferHex) {
            int n2 = 0;
            this.charref[n2++] = 38;
            this.charref[n2++] = 35;
            this.charref[n2++] = 120;
            String string = Integer.toHexString(n);
            int n3 = string.length();
            int n4 = 0;
            while (n4 < n3) {
                this.charref[n2++] = string.charAt(n4);
                ++n4;
            }
            this.charref[n2++] = 59;
            this.writer.write(this.charref, 0, n2);
        } else {
            int n5 = 0;
            this.charref[n5++] = 38;
            this.charref[n5++] = 35;
            String string = Integer.toString(n);
            int n6 = string.length();
            int n7 = 0;
            while (n7 < n6) {
                this.charref[n5++] = string.charAt(n7);
                ++n7;
            }
            this.charref[n5++] = 59;
            this.writer.write(this.charref, 0, n5);
        }
    }

    public void setEscaping(boolean bl) {
        this.escaping = bl;
    }

    public void comment(char[] cArray, int n, int n2) throws TransformerException {
        try {
            if (this.openStartTag) {
                this.closeStartTag(-1, false);
            }
            this.writer.write("<!--");
            this.writer.write(cArray, n, n2);
            this.writer.write("-->");
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    public void setResult(Result result) {
        if (!(result instanceof StreamResult)) {
            throw new IllegalArgumentException("Destination for XMLEmitter must be a StreamResult");
        }
        this.writer = ((StreamResult)result).getWriter();
        if (this.writer == null) {
            throw new IllegalArgumentException("No writer supplied");
        }
    }

    public void setOutputProperties(Properties properties) {
        this.characterSet = CharacterSetFactory.getCharacterSet(properties);
        super.setOutputProperties(properties);
    }

    public void setUnparsedEntity(String string, String string2) throws TransformerException {
    }

    static {
        int n = 0;
        while (n <= 127) {
            XMLEmitter.specialInText[n] = false;
            ++n;
        }
        XMLEmitter.specialInText[60] = true;
        XMLEmitter.specialInText[62] = true;
        XMLEmitter.specialInText[38] = true;
        specialInAtt = new boolean[128];
        int n2 = 0;
        while (n2 <= 127) {
            XMLEmitter.specialInAtt[n2] = false;
            ++n2;
        }
        XMLEmitter.specialInAtt[10] = true;
        XMLEmitter.specialInAtt[60] = true;
        XMLEmitter.specialInAtt[62] = true;
        XMLEmitter.specialInAtt[38] = true;
        XMLEmitter.specialInAtt[34] = true;
    }
}

